/*
 * Decompiled with CFR 0.152.
 */
package org.talend.parquet.hadoop;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.talend.parquet.data.Group;
import org.talend.parquet.data.GroupWriter;

public class TalendGroupWriteSupport
extends WriteSupport<Group> {
    public static final String PARQUET_SCHEMA = "parquet.talend.schema";
    private MessageType schema;
    private GroupWriter groupWriter;
    private Map<String, String> extraMetaData;

    public static void setSchema(MessageType schema, Configuration configuration) {
        configuration.set(PARQUET_SCHEMA, schema.toString());
    }

    public static MessageType getSchema(Configuration configuration) {
        return MessageTypeParser.parseMessageType((String)Objects.requireNonNull(configuration.get(PARQUET_SCHEMA), PARQUET_SCHEMA));
    }

    public TalendGroupWriteSupport() {
        this(null, new HashMap<String, String>());
    }

    TalendGroupWriteSupport(MessageType schema) {
        this(schema, new HashMap<String, String>());
    }

    TalendGroupWriteSupport(MessageType schema, Map<String, String> extraMetaData) {
        this.schema = schema;
        this.extraMetaData = extraMetaData;
    }

    public String getName() {
        return "Talend";
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        if (this.schema == null) {
            this.schema = TalendGroupWriteSupport.getSchema(configuration);
        }
        return new WriteSupport.WriteContext(this.schema, this.extraMetaData);
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.groupWriter = new GroupWriter(recordConsumer, (GroupType)this.schema);
    }

    public void write(Group record) {
        this.groupWriter.write(record);
    }
}

