/*
 * Decompiled with CFR 0.152.
 */
package org.talend.parquet.utils;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import jodd.time.JulianDate;
import org.talend.parquet.data.simple.NanoTime;

public class NanoTimeUtils {
    public static final long JULIAN_EPOCH_OFFSET_DAYS = 2440588L;
    private static final long MILLIS_IN_DAY = TimeUnit.DAYS.toMillis(1L);
    private static final long NANOS_PER_MILLISECOND = TimeUnit.MILLISECONDS.toNanos(1L);
    static final long NANOS_PER_HOUR = TimeUnit.HOURS.toNanos(1L);
    static final long NANOS_PER_MINUTE = TimeUnit.MINUTES.toNanos(1L);
    static final long NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
    static final long NANOS_PER_DAY = TimeUnit.DAYS.toNanos(1L);
    private static final ThreadLocal<Calendar> parquetGMTCalendar = new ThreadLocal();
    private static final ThreadLocal<Calendar> parquetLocalCalendar = new ThreadLocal();

    private static Calendar getGMTCalendar() {
        if (parquetGMTCalendar.get() == null) {
            parquetGMTCalendar.set(Calendar.getInstance(TimeZone.getTimeZone("GMT")));
        }
        return parquetGMTCalendar.get();
    }

    private static Calendar getLocalCalendar() {
        if (parquetLocalCalendar.get() == null) {
            parquetLocalCalendar.set(Calendar.getInstance());
        }
        return parquetLocalCalendar.get();
    }

    private static Calendar getCalendar(boolean skipConversion) {
        Calendar calendar = skipConversion ? NanoTimeUtils.getLocalCalendar() : NanoTimeUtils.getGMTCalendar();
        calendar.clear();
        return calendar;
    }

    public static NanoTime getNanoTime(Timestamp ts, boolean skipConversion) {
        Calendar calendar = NanoTimeUtils.getCalendar(skipConversion);
        calendar.setTimeInMillis(ts.getTime());
        int year = calendar.get(1);
        if (calendar.get(0) == 0) {
            year = 1 - year;
        }
        JulianDate jDateTime = JulianDate.of((int)year, (int)(calendar.get(2) + 1), (int)calendar.get(5), (int)0, (int)0, (int)0, (int)0);
        int days = jDateTime.getJulianDayNumber();
        long hour = calendar.get(11);
        long minute = calendar.get(12);
        long second = calendar.get(13);
        long nanos = ts.getNanos();
        long nanosOfDay = nanos + NANOS_PER_SECOND * second + NANOS_PER_MINUTE * minute + NANOS_PER_HOUR * hour;
        return new NanoTime(days, nanosOfDay);
    }

    public static Timestamp getTimestamp(NanoTime nt, boolean skipConversion) {
        long nanosOfDay;
        long julianDay = nt.getJulianDay();
        long remainder = nanosOfDay = nt.getTimeOfDayNanos();
        julianDay += remainder / NANOS_PER_DAY;
        if ((remainder %= NANOS_PER_DAY) < 0L) {
            remainder += NANOS_PER_DAY;
            --julianDay;
        }
        JulianDate jDateTime = new JulianDate((double)julianDay);
        LocalDateTime datetime = jDateTime.toLocalDateTime();
        Calendar calendar = NanoTimeUtils.getCalendar(skipConversion);
        calendar.set(1, datetime.getYear());
        calendar.set(2, datetime.getMonthValue() - 1);
        calendar.set(5, datetime.getYear());
        int hour = (int)(remainder / NANOS_PER_HOUR);
        int minutes = (int)((remainder %= NANOS_PER_HOUR) / NANOS_PER_MINUTE);
        int seconds = (int)((remainder %= NANOS_PER_MINUTE) / NANOS_PER_SECOND);
        long nanos = remainder % NANOS_PER_SECOND;
        calendar.set(11, hour);
        calendar.set(12, minutes);
        calendar.set(13, seconds);
        Timestamp ts = new Timestamp(calendar.getTimeInMillis());
        ts.setNanos((int)nanos);
        return ts;
    }

    public static long getTimestampMillis(NanoTime nt) {
        long timeOfDayNanos = nt.getTimeOfDayNanos();
        int julianDay = nt.getJulianDay();
        return ((long)julianDay - 2440588L) * MILLIS_IN_DAY + timeOfDayNanos / NANOS_PER_MILLISECOND;
    }

    public static Timestamp getTimestamp(NanoTime nt) {
        Timestamp ts = new Timestamp(NanoTimeUtils.getTimestampMillis(nt));
        ts.setNanos((int)(nt.getTimeOfDayNanos() % 1000000000L));
        return ts;
    }
}

