/*
 * Decompiled with CFR 0.152.
 */
package org.talend.parquet.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.DecimalMetadata;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.talend.parquet.data.Group;
import org.talend.parquet.data.simple.NanoTime;
import org.talend.parquet.utils.NanoTimeUtils;

public class TalendParquetUtils {
    public static final String ARRAY_FIELD_NAME = "array";

    public static PrimitiveType createPrimitiveType(String fieldName, boolean nullable, String primitiveType, String originalTypeName) {
        OriginalType originalType = null;
        if (originalTypeName != null) {
            originalType = OriginalType.valueOf((String)originalTypeName);
        }
        return new PrimitiveType(nullable ? Type.Repetition.OPTIONAL : Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.valueOf((String)primitiveType), fieldName, originalType);
    }

    public static PrimitiveType createDecimalType(String fieldName, boolean nullable, int precision, int scale) {
        DecimalMetadata decimalMetadata = new DecimalMetadata(precision, scale);
        return new PrimitiveType(nullable ? Type.Repetition.OPTIONAL : Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, 16, fieldName, OriginalType.DECIMAL, decimalMetadata, null);
    }

    public static Type createGroupElementType(String fieldName, Object element) {
        if (element == null) {
            return (Type)((Types.PrimitiveBuilder)Types.repeated((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named(fieldName);
        }
        if (String.class.isInstance(element)) {
            return (Type)((Types.PrimitiveBuilder)Types.repeated((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named(fieldName);
        }
        if (Double.class.isInstance(element)) {
            return (Type)Types.repeated((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE).named(fieldName);
        }
        if (Float.class.isInstance(element)) {
            return (Type)Types.repeated((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT).named(fieldName);
        }
        if (Byte.class.isInstance(element)) {
            return (Type)((Types.PrimitiveBuilder)Types.repeated((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.INT_8)).named(fieldName);
        }
        if (Short.class.isInstance(element)) {
            return (Type)((Types.PrimitiveBuilder)Types.repeated((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.INT_16)).named(fieldName);
        }
        if (Integer.class.isInstance(element)) {
            return (Type)Types.repeated((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named(fieldName);
        }
        if (Long.class.isInstance(element)) {
            return (Type)Types.repeated((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).named(fieldName);
        }
        if (Boolean.class.isInstance(element)) {
            return (Type)Types.repeated((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN).named(fieldName);
        }
        if (Date.class.isInstance(element)) {
            return (Type)((Types.PrimitiveBuilder)Types.repeated((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).as(OriginalType.TIMESTAMP_MILLIS)).named(fieldName);
        }
        if (Group.class.isInstance(element)) {
            return ((Group)element).getType();
        }
        throw new IllegalArgumentException("Unsupported type: " + element.getClass().getCanonicalName() + " for group type field'" + fieldName + "'");
    }

    public static GroupType createGroupType(String fieldName, boolean nullable, Object element) {
        Types.GroupBuilder builder = null;
        builder = nullable ? Types.optionalGroup() : Types.requiredGroup();
        return (GroupType)((Types.GroupBuilder)((Types.GroupBuilder)builder.as(OriginalType.LIST)).addField(TalendParquetUtils.createGroupElementType(ARRAY_FIELD_NAME, element))).named(fieldName);
    }

    public static List<Object> groupFieldValueToList(Group group) {
        if (group == null) {
            return null;
        }
        ArrayList<Object> values = new ArrayList<Object>();
        int listSize = group.getFieldRepetitionCount(0);
        for (int elementIndex = 0; elementIndex < listSize; ++elementIndex) {
            Type elelemntType = group.getType().getType(0);
            if (elelemntType.isPrimitive()) {
                PrimitiveType pType = elelemntType.asPrimitiveType();
                switch (pType.getPrimitiveTypeName()) {
                    case INT64: {
                        if (OriginalType.TIMESTAMP_MILLIS == elelemntType.getOriginalType()) {
                            values.add(new Date(group.getLong(0, elementIndex)));
                            break;
                        }
                        values.add(group.getLong(0, elementIndex));
                        break;
                    }
                    case INT32: {
                        values.add(group.getInteger(0, elementIndex));
                        break;
                    }
                    case BOOLEAN: {
                        values.add(group.getBoolean(0, elementIndex));
                        break;
                    }
                    case INT96: {
                        Binary value = group.getInt96(0, elementIndex);
                        if (value != null) {
                            NanoTime nanoTime = NanoTime.fromBinary(value);
                            values.add(new Date(NanoTimeUtils.getTimestamp(nanoTime, false).getTime()));
                            break;
                        }
                        values.add(value);
                        break;
                    }
                    case FLOAT: {
                        values.add(group.getFloat(0, elementIndex));
                        break;
                    }
                    case DOUBLE: {
                        values.add(group.getDouble(0, elementIndex));
                        break;
                    }
                    default: {
                        values.add(group.getValueToString(0, elementIndex));
                        break;
                    }
                }
                continue;
            }
            values.add(TalendParquetUtils.groupFieldValueToList(group.getGroup(0, elementIndex)));
        }
        return values;
    }

    public static void writeGroupField(Group nestGroup, List<?> values) {
        if (values == null || values.isEmpty()) {
            return;
        }
        for (int i = 0; i < values.size(); ++i) {
            Object element = values.get(i);
            if (String.class.isInstance(element)) {
                nestGroup.add(0, (String)element);
                continue;
            }
            if (Double.class.isInstance(element)) {
                nestGroup.add(0, (double)((Double)element));
                continue;
            }
            if (Float.class.isInstance(element)) {
                nestGroup.add(0, ((Float)element).floatValue());
                continue;
            }
            if (Byte.class.isInstance(element)) {
                nestGroup.add(0, (int)((Byte)element).byteValue());
                continue;
            }
            if (Short.class.isInstance(element)) {
                nestGroup.add(0, (int)((Short)element).shortValue());
                continue;
            }
            if (Integer.class.isInstance(element)) {
                nestGroup.add(0, (int)((Integer)element));
                continue;
            }
            if (Long.class.isInstance(element)) {
                nestGroup.add(0, (long)((Long)element));
                continue;
            }
            if (Boolean.class.isInstance(element)) {
                nestGroup.add(0, (boolean)((Boolean)element));
                continue;
            }
            if (Date.class.isInstance(element)) {
                nestGroup.add(0, ((Date)element).getTime());
                continue;
            }
            if (Group.class.isInstance(element)) {
                nestGroup.add(0, (Group)element);
                continue;
            }
            throw new IllegalArgumentException("Unsupported type: " + element.getClass().getCanonicalName() + " for group type field'" + nestGroup + "'");
        }
    }

    public static BigDecimal binaryToDecimal(Binary value, int precision, int scale) {
        if (precision <= 18) {
            ByteBuffer buffer = value.toByteBuffer();
            byte[] bytes = buffer.array();
            int start = buffer.arrayOffset() + buffer.position();
            int end = buffer.arrayOffset() + buffer.limit();
            long unscaled = 0L;
            for (int i = start; i < end; ++i) {
                unscaled = unscaled << 8 | (long)(bytes[i] & 0xFF);
            }
            int bits = 8 * (end - start);
            long unscaledNew = unscaled << 64 - bits >> 64 - bits;
            if (scale == 0 || (double)unscaledNew <= -Math.pow(10.0, 18.0) || (double)unscaledNew >= Math.pow(10.0, 18.0)) {
                return new BigDecimal(unscaledNew);
            }
            return BigDecimal.valueOf((double)unscaledNew / Math.pow(10.0, scale));
        }
        return new BigDecimal(new BigInteger(value.getBytes()), scale);
    }

    public static Binary decimalToBinary(BigDecimal decimalValue, int scale) {
        decimalValue = decimalValue.setScale(scale, RoundingMode.HALF_UP);
        BigInteger unscaledDecimalValue = decimalValue.unscaledValue();
        byte[] decimalBuffer = null;
        byte[] decimalBytes = unscaledDecimalValue.toByteArray();
        decimalBuffer = decimalValue.compareTo(BigDecimal.ZERO) < 0 ? new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1} : new byte[16];
        if (decimalBuffer.length >= decimalBytes.length) {
            int decimalBufferIndex = decimalBuffer.length - 1;
            for (int i = decimalBytes.length - 1; i >= 0; --i) {
                decimalBuffer[decimalBufferIndex] = decimalBytes[i];
                --decimalBufferIndex;
            }
        } else {
            throw new IllegalArgumentException(String.format("Decimal size: %d was greater than the allowed max: %d", decimalBytes.length, decimalBuffer.length));
        }
        return Binary.fromReusedByteArray((byte[])decimalBuffer);
    }
}

