/*
 * Copyright (C) 2006-2024 Talend Inc. - www.talend.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package org.talend.webservice.exception;

/**
 *
 * @author rlamarche
 */
public class InvalidEnumValueException extends LocalizedException {

    /**
     * Constructs an instance of <code>InvalidEnumValueException</code> with the specified detail message.
     * 
     * @param msg the detail message.
     */
    public InvalidEnumValueException(String value, String enumeration) {
        super("org.talend.ws.exception.InvalidEnumValueException", new String[] { value, enumeration });
    }

    public String getValue() {
        return (String) arguments[0];
    }

    public String getEnum() {
        return (String) arguments[1];
    }
}
