/*
 * Copyright (C) 2006-2024 Talend Inc. - www.talend.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package org.talend.webservice.mapper;

import java.util.Map;
import javax.wsdl.Message;

import org.talend.webservice.exception.LocalizedException;

/**
 * Define the transformation between params and Message parts
 * 
 * @author rlamarche
 */
public interface MessageMapper {

    /**
     * @return the targeted message
     */
    public Message getMessage();

    /**
     * Convert value to parts
     * 
     * @param value
     * @return
     */
    public Object[] convertToParams(Object value) throws LocalizedException;;

    /**
     * Convert parts to value
     * 
     * @param params
     * @return
     */
    public Map<String, Object> convertToValue(Object[] params) throws LocalizedException;

    public boolean isUnwrapped();

    public void setUnwrapped(boolean unwrapped);
}
