/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.multitenant.context;

import java.util.Optional;
import org.talend.daikon.multitenant.context.NoCurrentTenantException;
import org.talend.daikon.multitenant.context.TenancyContext;
import org.talend.daikon.multitenant.core.Tenant;

public class DefaultTenancyContext
implements TenancyContext {
    private static final long serialVersionUID = 1L;
    private Tenant tenant;

    @Override
    public Tenant getTenant() {
        if (this.tenant == null) {
            throw new NoCurrentTenantException("No tenant in running context");
        }
        return this.tenant;
    }

    @Override
    public void setTenant(Tenant tenant) {
        this.tenant = tenant;
    }

    @Override
    public Optional<Tenant> getOptionalTenant() {
        return Optional.ofNullable(this.tenant);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tenant == null ? 0 : this.tenant.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultTenancyContext other = (DefaultTenancyContext)obj;
        return !(this.tenant == null ? other.tenant != null : !this.tenant.equals(other.tenant));
    }

    public String toString() {
        return "DefaultTenancyContext [tenant=" + this.tenant + "]";
    }
}

