/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.multitenant.context;

import java.lang.reflect.Constructor;
import java.lang.reflect.UndeclaredThrowableException;
import org.talend.daikon.multitenant.context.GlobalTenancyContextHolderStrategy;
import org.talend.daikon.multitenant.context.InheritableThreadLocalTenancyContextHolderStrategy;
import org.talend.daikon.multitenant.context.TenancyContext;
import org.talend.daikon.multitenant.context.TenancyContextHolderStrategy;
import org.talend.daikon.multitenant.context.ThreadLocalTenancyContextHolderStrategy;

public class TenancyContextHolder {
    public static final String MODE_THREADLOCAL = "MODE_THREADLOCAL";
    public static final String MODE_INHERITABLETHREADLOCAL = "MODE_INHERITABLETHREADLOCAL";
    public static final String MODE_GLOBAL = "MODE_GLOBAL";
    public static final String SYSTEM_PROPERTY = "talend.tenancy.strategy";
    private static TenancyContextHolderStrategy strategy = new ThreadLocalTenancyContextHolderStrategy();
    private static String strategyName = System.getProperty("talend.tenancy.strategy");
    private static int initializeCount;

    public static void clearContext() {
        strategy.clearContext();
    }

    public static TenancyContext getContext() {
        return strategy.getContext();
    }

    public static void setContext(TenancyContext context) {
        strategy.setContext(context);
    }

    public static TenancyContext createEmptyContext() {
        return strategy.createEmptyContext();
    }

    public static TenancyContextHolderStrategy getStrategy() {
        return strategy;
    }

    public static void setStrategy(TenancyContextHolderStrategy strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException();
        }
        TenancyContextHolder.strategy = strategy;
    }

    public static int getInitializeCount() {
        return initializeCount;
    }

    private static void initialize() {
        if (strategyName == null || "".equals(strategyName)) {
            strategyName = MODE_THREADLOCAL;
        }
        if (strategyName.equals(MODE_THREADLOCAL)) {
            strategy = new ThreadLocalTenancyContextHolderStrategy();
        } else if (strategyName.equals(MODE_INHERITABLETHREADLOCAL)) {
            strategy = new InheritableThreadLocalTenancyContextHolderStrategy();
        } else if (strategyName.equals(MODE_GLOBAL)) {
            strategy = new GlobalTenancyContextHolderStrategy();
        } else {
            try {
                Class<?> clazz = Class.forName(strategyName);
                Constructor<?> customStrategy = clazz.getConstructor(new Class[0]);
                strategy = (TenancyContextHolderStrategy)customStrategy.newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw new UndeclaredThrowableException(ex);
            }
        }
        ++initializeCount;
    }

    public static void setStrategyName(String strategyName) {
        TenancyContextHolder.strategyName = strategyName;
        TenancyContextHolder.initialize();
    }

    public String toString() {
        return "TenancyContextHolder[strategy='" + strategyName + "'; initializeCount=" + initializeCount + "]";
    }

    static {
        TenancyContextHolder.initialize();
    }
}

