/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.interpreter;

import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Arrays;

public class ExprInterpreterConstants {
    public static final DateTimeFormatter DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("uuuu-MM-dd['T'HH:mm:ss][.SSS][xxx][xx][X]").parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).parseDefaulting(ChronoField.NANO_OF_SECOND, 0L).parseDefaulting(ChronoField.OFFSET_SECONDS, 0L).toFormatter();
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("[yyyy/MM/dd][yyyy-MM-dd][yyyyMMdd]");

    public static enum DateTimeConstantType {
        DATE("Date"),
        DAY("Days", "Day", "Day of Month", "d"),
        DAY_OF_YEAR("Day of Year", "D"),
        DAY_OF_WEEK("Day of Week", "e", "E"),
        HOUR("Hour", "Hours", "H"),
        MILLISECOND("Millisecond", "Milliseconds", "A"),
        MINUTE("Minute", "Minutes", "m"),
        MONTH("Month", "Months", "M", "L"),
        SECOND("Second", "Seconds", "s"),
        TIME("Time"),
        TIMEZONE("TimeZone", "V", "z"),
        WEEK("Weeks", "Week", "W"),
        WEEK_OF_YEAR("Week of Year", "w"),
        YEAR("Year", "Years", "Y", "u"),
        EPOCHSECOND("EpochSecond", "EpochSeconds", "Epoch");

        private String[] values;

        private DateTimeConstantType(String ... value) {
            this.values = value;
        }

        public static DateTimeConstantType getType(String value) {
            block3: {
                block2: {
                    if (value.length() <= 1) break block2;
                    for (DateTimeConstantType valueType : DateTimeConstantType.values()) {
                        boolean contains = Arrays.stream(valueType.values).anyMatch(value::equalsIgnoreCase);
                        if (!contains) continue;
                        return valueType;
                    }
                    break block3;
                }
                if (value.length() != 1) break block3;
                for (DateTimeConstantType valueType : DateTimeConstantType.values()) {
                    boolean contains = Arrays.stream(valueType.values).anyMatch(value::equals);
                    if (!contains) continue;
                    return valueType;
                }
            }
            return null;
        }
    }
}

