/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.interpreter.impl;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.maplang.el.interpreter.Messages;
import org.talend.maplang.el.interpreter.api.DselHPathStore;
import org.talend.maplang.el.interpreter.api.ExprEvalVisitor;
import org.talend.maplang.el.interpreter.api.ExprInterpreter;
import org.talend.maplang.el.interpreter.api.ExprInterpreterConfiguration;
import org.talend.maplang.el.interpreter.api.ExprInterpreterException;
import org.talend.maplang.el.interpreter.api.ExprLangContext;
import org.talend.maplang.el.interpreter.api.ExprLangFunction;
import org.talend.maplang.el.interpreter.api.InterpreterErrorMessageProvider;
import org.talend.maplang.el.interpreter.impl.CustomOperatorsImpl;
import org.talend.maplang.el.interpreter.impl.DefaultInterpreterErrorMessageProvider;
import org.talend.maplang.el.interpreter.impl.ExprEvalVisitorImpl;
import org.talend.maplang.el.interpreter.impl.ExprValue;
import org.talend.maplang.el.interpreter.impl.function.ExprLangFunctions;
import org.talend.maplang.el.parser.CustomOperators;
import org.talend.maplang.el.parser.DSLFunctions;
import org.talend.maplang.el.parser.ExprLangException;
import org.talend.maplang.el.parser.ExprParser;
import org.talend.maplang.el.parser.model.ELNode;
import org.talend.maplang.hpath.HPathStore;

public class ExprInterpreterImpl
implements ExprInterpreter {
    private static final Logger LOG = LoggerFactory.getLogger(ExprInterpreterImpl.class);
    private String _input;
    private ELNode _model = null;
    private ExprEvalVisitor _visitor = null;
    private final ExprLangContext _context;

    public ExprInterpreterImpl(ExprLangContext context) {
        this(context, null);
    }

    public ExprInterpreterImpl(ExprLangContext context, ExprInterpreterConfiguration configuration) {
        this._context = ExprInterpreterImpl.initContext(context);
        this._visitor = this.initVisitor(context, configuration);
        this._visitor.setErrorMessageProvider(this.initErrorMessageProvider(context, configuration));
    }

    private ExprEvalVisitor initVisitor(ExprLangContext context, ExprInterpreterConfiguration configuration) {
        ExprEvalVisitor visitor = null;
        if (configuration != null) {
            visitor = configuration.getVisitor(context);
        }
        if (visitor == null) {
            visitor = new ExprEvalVisitorImpl(context);
        }
        return visitor;
    }

    private InterpreterErrorMessageProvider initErrorMessageProvider(ExprLangContext context, ExprInterpreterConfiguration configuration) {
        InterpreterErrorMessageProvider errorMessageProvider = null;
        if (configuration != null) {
            errorMessageProvider = configuration.getErrorMessageProvider(context);
        }
        if (errorMessageProvider == null) {
            errorMessageProvider = new DefaultInterpreterErrorMessageProvider();
        }
        return errorMessageProvider;
    }

    @Override
    public ExprInterpreter setExpression(String expression) {
        this._input = expression;
        this._model = null;
        return this;
    }

    @Override
    public ExprInterpreter setModel(ELNode model) {
        this._input = null;
        this._model = model;
        return this;
    }

    @Override
    public ExprInterpreter storeValue(String key, Object value) {
        this.getStore().put(key, value);
        return this;
    }

    @Override
    public ExprInterpreter storeValues(Map<String, Object> values) {
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            this.getStore().put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public Object eval() {
        return this.evalAsExprValue().getValue();
    }

    @Override
    public Boolean evalAsBoolean() {
        return this.evalAsExprValue().booleanValue();
    }

    @Override
    public Integer evalAsInteger() {
        return this.evalAsExprValue().intValue();
    }

    @Override
    public Double evalAsDouble() {
        return this.evalAsExprValue().doubleValue();
    }

    @Override
    public Float evalAsFloat() {
        return this.evalAsExprValue().floatValue();
    }

    @Override
    public Long evalAsLong() {
        return this.evalAsExprValue().longValue();
    }

    @Override
    public String evalAsString() {
        return this.evalAsExprValue().stringValue();
    }

    @Override
    public BigDecimal evalAsBigDecimal() {
        return this.evalAsExprValue().bigDecimalValue();
    }

    @Override
    public byte[] evalAsBytes() {
        return this.evalAsExprValue().bytesValue();
    }

    @Override
    public OffsetDateTime evalAsDateTime() {
        return this.evalAsExprValue().dateTimeValue();
    }

    @Override
    public LocalDate evalAsDate() {
        return this.evalAsExprValue().dateValue();
    }

    @Override
    public LocalTime evalAsTime() {
        return this.evalAsExprValue().timeValue();
    }

    private ELNode buildModel() {
        if (this._input == null) {
            throw new ExprInterpreterException(Messages.getMessage("ExprInterpreterImpl.NoExpression", new Object[0]));
        }
        ExprParser parser = new ExprParser();
        parser.setDslFunctions(this.getDslFunctions());
        parser.setCustomOperators(this.getCustomOperators());
        try {
            return parser.parse(this._input);
        }
        catch (ExprLangException e) {
            throw new ExprInterpreterException(e.getMessage());
        }
    }

    private DSLFunctions getDslFunctions() {
        return new ExprLangFunctions(this.getContext());
    }

    private CustomOperators getCustomOperators() {
        return new CustomOperatorsImpl(this.getContext());
    }

    private ELNode getModel() {
        if (this._model == null) {
            this._model = this.buildModel();
        }
        return this._model;
    }

    public ExprValue evalAsExprValue() {
        ELNode model = this.getModel();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Evaluate EL expression: " + model.toString());
        }
        ExprValue result = model.accept(this._visitor);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Evaluation result: " + result.toString());
        }
        return result;
    }

    @Override
    public ExprInterpreter removeValue(String key) {
        this.getStore().remove(key);
        return this;
    }

    @Override
    public ExprLangContext getContext() {
        return this._context;
    }

    private HPathStore getStore() {
        return this._context.getStore();
    }

    public static ExprLangContext initContext(ExprLangContext context) {
        if (context.getStore() == null) {
            context.setStore(new DselHPathStore());
        }
        if (context.getJavaClassLoader() == null) {
            context.setJavaClassLoader(Thread.currentThread().getContextClassLoader());
        }
        if (context.getFunctions() == null) {
            context.setFunctions(ExprInterpreterImpl.loadFunctions(context));
        }
        return context;
    }

    private static Map<String, ExprLangFunction> loadFunctions(ExprLangContext context) {
        ConcurrentHashMap<String, ExprLangFunction> functions = new ConcurrentHashMap<String, ExprLangFunction>();
        ExprInterpreterImpl.loadFunctions(functions, ExprLangFunction.class.getClassLoader());
        if (context.getExtensionsClassLoader() != null) {
            ExprInterpreterImpl.loadFunctions(functions, context.getExtensionsClassLoader());
        }
        return functions;
    }

    private static void loadFunctions(Map<String, ExprLangFunction> functions, ClassLoader cl) {
        ServiceLoader<ExprLangFunction> loader = ServiceLoader.load(ExprLangFunction.class, cl);
        for (ExprLangFunction function : loader) {
            functions.put(function.getName().toLowerCase(), function);
        }
    }
}

