/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.interpreter.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import org.talend.maplang.el.interpreter.Messages;
import org.talend.maplang.el.interpreter.impl.ExprValueException;
import org.talend.maplang.el.interpreter.impl.ExprValueType;
import org.talend.maplang.el.interpreter.impl.ExprValueUtils;
import org.talend.maplang.el.interpreter.impl.MathUtil;
import org.talend.maplang.el.interpreter.impl.NullExprValueException;

public class ExprValue
implements Comparable<ExprValue> {
    private Object _value;
    private ExprValueType _type;

    protected ExprValue() {
    }

    public ExprValue(Object value) {
        this.init(value);
    }

    public ExprValue(String value, Class<?> clazz) {
        this(ExprValue.toObject(value, clazz));
    }

    protected final void init(Object value) {
        this._type = value == null ? ExprValueType.NULL : ExprValueType.getType(value.getClass());
        if (this._type == null) {
            throw new ExprValueException(Messages.getMessage("ExprValue.NotSupportedValueClass", value.getClass().getSimpleName()));
        }
        this._value = value;
    }

    public static boolean isSupported(Object value) {
        return value == null || ExprValueType.getType(value.getClass()) != null;
    }

    private static Object toObject(String value, Class<?> clazz) {
        if (clazz.equals(String.class)) {
            return ExprValueUtils.unQuote(value);
        }
        if (clazz.equals(Boolean.class)) {
            return Boolean.valueOf(value);
        }
        if (clazz.equals(byte[].class)) {
            if (!ExprValueUtils.isHexStringCandidate(value)) {
                throw new ExprValueException(Messages.getMessage("ExprValue.invalidHexadecimal", value));
            }
            return ExprValueUtils.hexStringToByteArray(value);
        }
        try {
            if (clazz.equals(BigDecimal.class)) {
                return new BigDecimal(value);
            }
        }
        catch (NumberFormatException e) {
            throw new ExprValueException(Messages.getMessage("ExprValue.invalidNumericConversion", value));
        }
        if (clazz.equals(Float.class)) {
            return ExprValue.toFloat(value);
        }
        if (clazz.equals(Double.class)) {
            return ExprValue.toDouble(value);
        }
        if (clazz.equals(Integer.class)) {
            return ExprValue.toInteger(value);
        }
        if (clazz.equals(Long.class)) {
            return ExprValue.toLong(value);
        }
        try {
            if (clazz.equals(LocalDate.class)) {
                return LocalDate.parse(value);
            }
            if (clazz.equals(OffsetDateTime.class)) {
                return OffsetDateTime.parse(value);
            }
            if (clazz.equals(LocalTime.class)) {
                return LocalTime.parse(value);
            }
        }
        catch (DateTimeParseException e) {
            throw new ExprValueException(Messages.getMessage("ExprValue.invalidDateTimeConversion", value));
        }
        throw new ExprValueException(Messages.getMessage("ExprValue.NotSupportedValueClass", clazz.getSimpleName()));
    }

    private static Integer toInteger(String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            ExprValue.checkIntegerOrLongOverflow(value, "ExprValue.integerOverflow");
            return null;
        }
    }

    private static Long toLong(String value) {
        String longValue = value;
        if (value.endsWith("L") || value.endsWith("l")) {
            longValue = value.substring(0, value.length() - 1);
        }
        try {
            return Long.valueOf(longValue);
        }
        catch (NumberFormatException e) {
            ExprValue.checkIntegerOrLongOverflow(longValue, "ExprValue.longOverflow");
            return null;
        }
    }

    private static void checkIntegerOrLongOverflow(String value, String errorMsg) {
        try {
            new BigInteger(value);
            throw new ExprValueException(Messages.getMessage(errorMsg, new Object[0]));
        }
        catch (NumberFormatException e2) {
            throw new ExprValueException(Messages.getMessage("ExprValue.invalidNumericConversion", value));
        }
    }

    private static Float toFloat(String value) {
        String floatValue = value;
        if (value.endsWith("F") || value.endsWith("f")) {
            floatValue = value.substring(0, value.length() - 1);
        }
        try {
            Float val = Float.valueOf(floatValue);
            if (Float.isInfinite(val.floatValue())) {
                throw new ExprValueException(Messages.getMessage("ExprValue.floatOverflow", new Object[0]));
            }
            return val;
        }
        catch (NumberFormatException e) {
            throw new ExprValueException(Messages.getMessage("ExprValue.invalidNumericConversion", value));
        }
    }

    private static Double toDouble(String value) {
        try {
            Double val = Double.valueOf(value);
            if (Double.isInfinite(val)) {
                throw new ExprValueException(Messages.getMessage("ExprValue.doubleOverflow", new Object[0]));
            }
            return val;
        }
        catch (NumberFormatException e) {
            throw new ExprValueException(Messages.getMessage("ExprValue.invalidNumericConversion", value));
        }
    }

    private void checkArithmeticOperandTypes(ExprValue b, String errorMsgId) {
        if (this.isNull() || b.isNull() || this.isDateTime() || b.isDateTime() || this.isDate() || b.isDate() || this.isTime() || b.isTime() || this.isBoolean() || b.isBoolean() || !this.isNumeric() && !b.isNumeric()) {
            throw new ExprValueException(Messages.getMessage(errorMsgId, new Object[0]));
        }
    }

    public ExprValue convertStringOperandToNumericIfPossible() {
        if (!this.isString()) {
            throw new ExprValueException(Messages.getMessage("ExprValue.unsupportedNumericConversion", this));
        }
        String s = (String)this.getValue();
        if (s == null || s.isEmpty()) {
            throw new ExprValueException(Messages.getMessage("ExprValue.emptyOrNullNumericConversion", new Object[0]));
        }
        Number value = null;
        try {
            value = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            value = null;
        }
        if (value == null) {
            if (s.endsWith("l") || s.endsWith("L")) {
                s = s.substring(0, s.length() - 1);
            }
            try {
                value = Long.parseLong(s);
            }
            catch (NumberFormatException e) {
                value = null;
            }
        }
        if (value == null && (s.endsWith("f") || s.endsWith("F"))) {
            try {
                value = Float.valueOf(Float.parseFloat(s));
            }
            catch (NumberFormatException e) {
                value = null;
            }
        }
        if (value == null && (s.endsWith("d") || s.endsWith("D") || s.contains("e") || s.contains("E"))) {
            try {
                value = Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                value = null;
            }
        }
        if (value == null) {
            try {
                value = new BigDecimal(s);
            }
            catch (NumberFormatException e) {
                value = null;
            }
        }
        if (value == null) {
            throw new ExprValueException(Messages.getMessage("ExprValue.invalidNumericConversion", s));
        }
        return new ExprValue(value);
    }

    public ExprValue add(ExprValue b) {
        ExprValue opB;
        this.checkArithmeticOperandTypes(b, "ExprValue.invalidSumOperands");
        Number result = null;
        ExprValue opA = this.isString() ? this.convertStringOperandToNumericIfPossible() : this;
        ExprValue exprValue = opB = b.isString() ? b.convertStringOperandToNumericIfPossible() : b;
        if (opA.isBigDecimal() || opB.isBigDecimal()) {
            result = opA.bigDecimalValue().add(opB.bigDecimalValue());
        } else if (opA.isDouble() || opB.isDouble()) {
            result = opA.doubleValue() + opB.doubleValue();
            this.checkFloatOrDoubleOverflow(result);
        } else if (opA.isFloat() || opB.isFloat()) {
            result = Float.valueOf(opA.floatValue().floatValue() + opB.floatValue().floatValue());
            this.checkFloatOrDoubleOverflow(result);
        } else {
            try {
                result = opA.isLong() || opB.isLong() ? (Number)Math.addExact(opA.longValue(), opB.longValue()) : (Number)Math.addExact(opA.intValue(), opB.intValue());
            }
            catch (ArithmeticException e) {
                throw new ExprValueException(e.getMessage(), e);
            }
        }
        return new ExprValue(result);
    }

    private void checkFloatOrDoubleOverflow(Object value) {
        if (value instanceof Float && Float.isInfinite(((Float)value).floatValue())) {
            throw new ExprValueException(Messages.getMessage("ExprValue.floatOverflow", new Object[0]));
        }
        if (value instanceof Double && Double.isInfinite((Double)value)) {
            throw new ExprValueException(Messages.getMessage("ExprValue.doubleOverflow", new Object[0]));
        }
    }

    public ExprValue subtract(ExprValue b) {
        ExprValue opB;
        this.checkArithmeticOperandTypes(b, "ExprValue.invalidSubtractionOperands");
        Number result = null;
        ExprValue opA = this.isString() ? this.convertStringOperandToNumericIfPossible() : this;
        ExprValue exprValue = opB = b.isString() ? b.convertStringOperandToNumericIfPossible() : b;
        if (opA.isBigDecimal() || opB.isBigDecimal()) {
            result = opA.bigDecimalValue().subtract(opB.bigDecimalValue());
        } else if (opA.isDouble() || opB.isDouble()) {
            result = opA.doubleValue() - opB.doubleValue();
            this.checkFloatOrDoubleOverflow(result);
        } else if (opA.isFloat() || opB.isFloat()) {
            result = Float.valueOf(opA.floatValue().floatValue() - opB.floatValue().floatValue());
            this.checkFloatOrDoubleOverflow(result);
        } else {
            try {
                result = opA.isLong() || opB.isLong() ? (Number)Math.subtractExact(opA.longValue(), opB.longValue()) : (Number)Math.subtractExact(opA.intValue(), opB.intValue());
            }
            catch (ArithmeticException e) {
                throw new ExprValueException(e.getMessage(), e);
            }
        }
        return new ExprValue(result);
    }

    public ExprValue multiply(ExprValue b) {
        ExprValue opB;
        this.checkArithmeticOperandTypes(b, "ExprValue.invalidMultiplicationOperands");
        Number result = null;
        ExprValue opA = this.isString() ? this.convertStringOperandToNumericIfPossible() : this;
        ExprValue exprValue = opB = b.isString() ? b.convertStringOperandToNumericIfPossible() : b;
        if (opA.isBigDecimal() || opB.isBigDecimal()) {
            result = opA.bigDecimalValue().multiply(opB.bigDecimalValue());
        } else if (opA.isDouble() || opB.isDouble()) {
            result = opA.doubleValue() * opB.doubleValue();
            this.checkFloatOrDoubleOverflow(result);
        } else if (opA.isFloat() || opB.isFloat()) {
            result = Float.valueOf(opA.floatValue().floatValue() * opB.floatValue().floatValue());
            this.checkFloatOrDoubleOverflow(result);
        } else {
            try {
                result = opA.isLong() || opB.isLong() ? (Number)Math.multiplyExact((long)opA.longValue(), opB.longValue()) : (Number)Math.multiplyExact(opA.intValue(), (int)opB.intValue());
            }
            catch (ArithmeticException e) {
                throw new ExprValueException(e.getMessage(), e);
            }
        }
        return new ExprValue(result);
    }

    public ExprValue divide(ExprValue b) {
        this.checkArithmeticOperandTypes(b, "ExprValue.invalidDivisionOperands");
        Number result = null;
        ExprValue opA = this.isString() ? this.convertStringOperandToNumericIfPossible() : this;
        ExprValue opB = b.isString() ? b.convertStringOperandToNumericIfPossible() : b;
        try {
            if (opA.isBigDecimal() || opB.isBigDecimal()) {
                result = this.divide(opA.bigDecimalValue(), opB.bigDecimalValue());
            } else if (opA.isDouble() || opB.isDouble()) {
                result = opA.doubleValue() / opB.doubleValue();
            } else if (opA.isFloat() || opB.isFloat()) {
                result = Float.valueOf(opA.floatValue().floatValue() / opB.floatValue().floatValue());
            } else if (opA.isLong() || opB.isLong()) {
                Long valueA = opA.longValue();
                Long valueB = opB.longValue();
                result = valueA % valueB == 0L ? (Number)(valueA / valueB) : (Number)(valueA.doubleValue() / valueB.doubleValue());
            } else {
                Integer valueA = opA.intValue();
                Integer valueB = opB.intValue();
                result = valueA % valueB == 0 ? (Number)(valueA / valueB) : (Number)Float.valueOf(valueA.floatValue() / valueB.floatValue());
            }
        }
        catch (ArithmeticException e) {
            throw new ExprValueException(e.getMessage(), e);
        }
        return new ExprValue(result);
    }

    private BigDecimal divide(BigDecimal a, BigDecimal b) {
        return a.divide(b, Math.max(a.precision(), b.precision()), RoundingMode.HALF_UP);
    }

    public ExprValue modulo(ExprValue b) {
        ExprValue opB;
        this.checkArithmeticOperandTypes(b, "ExprValue.InvalidModuloOperands");
        ExprValue opA = this.isString() ? this.convertStringOperandToNumericIfPossible() : this;
        ExprValue exprValue = opB = b.isString() ? b.convertStringOperandToNumericIfPossible() : b;
        if (opA.isLong() || opB.isLong()) {
            return new ExprValue(opA.longValue() % opB.longValue());
        }
        return new ExprValue(opA.intValue() % opB.intValue());
    }

    public ExprValue or(ExprValue b) {
        return new ExprValue(this.booleanValue() != false || b.booleanValue() != false);
    }

    public ExprValue and(ExprValue b) {
        return new ExprValue(this.booleanValue() != false && b.booleanValue() != false);
    }

    public ExprValue greaterThan(ExprValue b) {
        return new ExprValue(this.compareTo(b) > 0);
    }

    public ExprValue greaterOrEqual(ExprValue b) {
        return new ExprValue(this.compareTo(b) >= 0);
    }

    public ExprValue equal(ExprValue b) {
        if (this.isNull() || b.isNull()) {
            return new ExprValue(this.isNull() && b.isNull());
        }
        return new ExprValue(this.compareTo(b) == 0);
    }

    public ExprValue notEqual(ExprValue b) {
        if (this.isNull() || b.isNull()) {
            return new ExprValue(this.isNull() != b.isNull());
        }
        return new ExprValue(this.compareTo(b) != 0);
    }

    public ExprValue lowerThan(ExprValue b) {
        return new ExprValue(this.compareTo(b) < 0);
    }

    public ExprValue lowerOrEqual(ExprValue b) {
        return new ExprValue(this.compareTo(b) <= 0);
    }

    public ExprValue not() {
        Boolean boolVal = this.booleanValue();
        Boolean notBoolVal = boolVal == null ? null : Boolean.valueOf(boolVal == false);
        return new ExprValue(notBoolVal);
    }

    private int compare(double x, double y) {
        if (MathUtil.equals(x, y)) {
            return 0;
        }
        if (x > y) {
            return 1;
        }
        return -1;
    }

    private int compare(double x, double y, double epsilon) {
        if (MathUtil.equals(x, y, epsilon)) {
            return 0;
        }
        if (x > y) {
            return 1;
        }
        return -1;
    }

    private int compare(float x, float y) {
        if (MathUtil.equals(x, y)) {
            return 0;
        }
        if (x > y) {
            return 1;
        }
        return -1;
    }

    private int compare(float x, float y, float epsilon) {
        if (MathUtil.equals(x, y, epsilon)) {
            return 0;
        }
        if (x > y) {
            return 1;
        }
        return -1;
    }

    private int compare(byte[] x, byte[] y) {
        if (Arrays.equals(x, y)) {
            return 0;
        }
        return new BigInteger(x).compareTo(new BigInteger(y));
    }

    public int compareTo(ExprValue b, ExprValue epsilon) {
        if (this.isNull() || b.isNull()) {
            throw new ExprValueException(Messages.getMessage("ExprValue.nullOperandInComparison", new Object[0]));
        }
        if (!this.canBeComparedWithEpsilonTo(b)) {
            throw new ExprValueException(Messages.getMessage("ExprValue.invalidOperandTypesInComparisonWithEpsilon", new Object[]{this.getType(), b.getType()}));
        }
        if (!epsilon.isFloat() && !epsilon.isDouble()) {
            throw new ExprValueException(Messages.getMessage("ExprValue.invalidEpsilon", epsilon));
        }
        ExprValue opA = this;
        ExprValue opB = b;
        if (this.isNumeric() || b.isNumeric()) {
            opA = this.isString() ? this.convertStringOperandToNumericIfPossible() : opA;
            ExprValue exprValue = opB = b.isString() ? b.convertStringOperandToNumericIfPossible() : opB;
        }
        if (opA.isBigDecimal() || opB.isBigDecimal()) {
            return this.compare(opA.doubleValue(), opB.doubleValue(), epsilon.doubleValue());
        }
        if (opA.isDouble() || opB.isDouble()) {
            return this.compare(opA.doubleValue(), opB.doubleValue(), epsilon.doubleValue());
        }
        if (opA.isFloat() || opB.isFloat()) {
            return this.compare(opA.floatValue().floatValue(), opB.floatValue().floatValue(), epsilon.floatValue().floatValue());
        }
        if (opA.isLong() || opB.isLong()) {
            return this.compare(opA.floatValue().floatValue(), opB.floatValue().floatValue(), epsilon.floatValue().floatValue());
        }
        return this.compare(opA.floatValue().floatValue(), opB.floatValue().floatValue(), epsilon.floatValue().floatValue());
    }

    @Override
    public int compareTo(ExprValue b) {
        if (this.isNull() || b.isNull()) {
            throw new ExprValueException(Messages.getMessage("ExprValue.nullOperandInComparison", new Object[0]));
        }
        if (!this.canBeComparedTo(b)) {
            throw new ExprValueException(Messages.getMessage("ExprValue.invalidOperandTypesInComparison", new Object[]{this.getType(), b.getType()}));
        }
        ExprValue opA = this;
        ExprValue opB = b;
        if (this.isNumeric() || b.isNumeric()) {
            opA = this.isString() ? this.convertStringOperandToNumericIfPossible() : opA;
            ExprValue exprValue = opB = b.isString() ? b.convertStringOperandToNumericIfPossible() : opB;
        }
        if (opA.isBigDecimal() || opB.isBigDecimal()) {
            return opA.bigDecimalValue().compareTo(opB.bigDecimalValue());
        }
        if (opA.isDouble() || opB.isDouble()) {
            return this.compare(opA.doubleValue(), opB.doubleValue());
        }
        if (opA.isFloat() || opB.isFloat()) {
            return this.compare(opA.floatValue().floatValue(), opB.floatValue().floatValue());
        }
        if (opA.isLong() || opB.isLong()) {
            return opA.longValue().compareTo(opB.longValue());
        }
        if (opA.isInteger() || opB.isInteger()) {
            return opA.intValue().compareTo(opB.intValue());
        }
        if (opA.isBoolean() || opB.isBoolean()) {
            return opA.booleanValue().compareTo(opB.booleanValue());
        }
        if (opA.isBytes() || opB.isBytes()) {
            return this.compare(opA.bytesValue(), opB.bytesValue());
        }
        if (opA.isDateTime() || opB.isDateTime()) {
            return opA.dateTimeValue().compareTo(opB.dateTimeValue());
        }
        if (opA.isDate() || opB.isDate()) {
            return opA.dateValue().compareTo(opB.dateValue());
        }
        if (opA.isTime() || opB.isTime()) {
            return opA.timeValue().compareTo(opB.timeValue());
        }
        return opA.stringValue().compareTo(opB.stringValue());
    }

    public boolean canBeComparedTo(ExprValue b) {
        switch (this.getType()) {
            case STRING: {
                return b.isNotType(ExprValueType.NULL);
            }
            case BOOLEAN: {
                return b.isType(ExprValueType.BOOLEAN, ExprValueType.STRING);
            }
            case BIGDECIMAL: 
            case DOUBLE: 
            case FLOAT: 
            case INTEGER: 
            case LONG: 
            case BYTES: {
                return b.isNotType(ExprValueType.BOOLEAN, ExprValueType.DATE, ExprValueType.TIME, ExprValueType.DATETIME, ExprValueType.NULL);
            }
            case DATE: 
            case DATETIME: {
                return b.isType(ExprValueType.STRING, ExprValueType.DATE, ExprValueType.DATETIME);
            }
            case TIME: {
                return b.isType(ExprValueType.STRING, ExprValueType.TIME);
            }
        }
        return false;
    }

    public boolean canBeComparedWithEpsilonTo(ExprValue b) {
        switch (this.getType()) {
            case STRING: 
            case BYTES: {
                return b.isNumeric();
            }
            case BIGDECIMAL: 
            case DOUBLE: 
            case FLOAT: 
            case INTEGER: 
            case LONG: {
                return b.isNumeric() || b.isType(ExprValueType.STRING, ExprValueType.BYTES);
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExprValue other = (ExprValue)obj;
        if (this._type != other._type) {
            return false;
        }
        return !(this._value == null ? other._value != null : !this._value.equals(other._value));
    }

    public BigDecimal bigDecimalValue() {
        if (this.isNull()) {
            throw new NullExprValueException(Messages.getMessage("ExprValue.cannotCastNull", new Object[]{ExprValueType.BIGDECIMAL}));
        }
        if (this.isBigDecimal()) {
            return (BigDecimal)this._value;
        }
        if (this.isBytes()) {
            BigInteger b = new BigInteger((byte[])this._value);
            return new BigDecimal(b);
        }
        if (this.isInteger()) {
            return BigDecimal.valueOf(((Integer)this._value).intValue());
        }
        if (this.isLong()) {
            return BigDecimal.valueOf((Long)this._value);
        }
        if (this.isFloat()) {
            return BigDecimal.valueOf(((Float)this._value).floatValue());
        }
        if (this.isDouble()) {
            return BigDecimal.valueOf((Double)this._value);
        }
        if (this.isString()) {
            return new BigDecimal((String)this._value);
        }
        if (this.isBoolean()) {
            return BigDecimal.valueOf(this.booleanValue() != false ? 1L : 0L);
        }
        throw new ExprValueException(Messages.getMessage("ExprValue.cannotCastToDecimal", this._value));
    }

    public byte[] bytesValue() {
        if (this.isNull()) {
            throw new NullExprValueException(Messages.getMessage("ExprValue.cannotCastNull", new Object[]{ExprValueType.BYTES}));
        }
        if (this.isBytes()) {
            return (byte[])this._value;
        }
        if (this.isBigDecimal()) {
            return this.bigDecimalValue().toBigInteger().toByteArray();
        }
        if (this.isBoolean()) {
            byte[] array = new byte[]{(byte)(this.booleanValue() == true ? 1 : 0)};
            return array;
        }
        if (this.isLong()) {
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.putLong((Long)this._value);
            return buffer.array();
        }
        if (this.isInteger()) {
            return ExprValueUtils.intToByteArray((Integer)this._value);
        }
        if (this.isFloat()) {
            ByteBuffer buffer = ByteBuffer.allocate(4);
            buffer.putFloat(((Float)this._value).floatValue());
            return buffer.array();
        }
        if (this.isDouble()) {
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.putDouble((Double)this._value);
            return buffer.array();
        }
        if (this.isString()) {
            return ExprValueUtils.stringToByteArray((String)this._value);
        }
        if (this.isDateTime()) {
            OffsetDateTime dateTime = (OffsetDateTime)this._value;
            ByteBuffer buffer = ByteBuffer.allocate(8);
            return buffer.putLong(dateTime.toEpochSecond()).array();
        }
        if (this.isDate()) {
            LocalDate date = (LocalDate)this._value;
            ByteBuffer buffer = ByteBuffer.allocate(8);
            return buffer.putLong(date.toEpochDay()).array();
        }
        if (this.isTime()) {
            LocalTime time = (LocalTime)this._value;
            ByteBuffer buffer = ByteBuffer.allocate(8);
            return buffer.putLong(time.toNanoOfDay()).array();
        }
        throw new ExprValueException(Messages.getMessage("ExprValue.cannotCastToBytes", this._value));
    }

    public Object toValue(ExprValueType dataType) {
        switch (dataType) {
            case INTEGER: {
                return this.intValue();
            }
            case DOUBLE: {
                return this.doubleValue();
            }
            case STRING: {
                return this.stringValue();
            }
            case LONG: {
                return this.longValue();
            }
            case FLOAT: {
                return this.floatValue();
            }
            case BOOLEAN: {
                return this.booleanValue();
            }
            case BYTES: {
                return this.bytesValue();
            }
            case TIME: {
                return this.timeValue();
            }
            case DATETIME: {
                return this.dateTimeValue();
            }
            case DATE: {
                return this.dateValue();
            }
        }
        return this._value;
    }

    public Integer intValue() {
        if (this.isNull()) {
            throw new NullExprValueException(Messages.getMessage("ExprValue.cannotCastNull", new Object[]{ExprValueType.INTEGER}));
        }
        if (this.isBigDecimal()) {
            return this.bigDecimalValue().intValue();
        }
        if (this.isBytes()) {
            return new BigInteger((byte[])this._value).intValue();
        }
        if (this.isInteger()) {
            return (Integer)this._value;
        }
        if (this.isLong()) {
            return ((Long)this._value).intValue();
        }
        if (this.isString()) {
            ExprValue numericValue = this.convertStringOperandToNumericIfPossible();
            return numericValue.intValue();
        }
        if (this.isFloat()) {
            return ((Float)this._value).intValue();
        }
        if (this.isDouble()) {
            return ((Double)this._value).intValue();
        }
        if (this.isBoolean()) {
            return this.booleanValue() != false ? 1 : 0;
        }
        throw new ExprValueException(Messages.getMessage("ExprValue.cannotCastToInteger", this._value));
    }

    public Long longValue() {
        if (this.isNull()) {
            throw new NullExprValueException(Messages.getMessage("ExprValue.cannotCastNull", new Object[]{ExprValueType.LONG}));
        }
        if (this.isBigDecimal()) {
            return this.bigDecimalValue().longValue();
        }
        if (this.isBytes()) {
            return new BigInteger((byte[])this._value).longValue();
        }
        if (this.isInteger()) {
            return ((Integer)this._value).longValue();
        }
        if (this.isLong()) {
            return (Long)this._value;
        }
        if (this.isString()) {
            ExprValue numericValue = this.convertStringOperandToNumericIfPossible();
            return numericValue.longValue();
        }
        if (this.isFloat()) {
            return ((Float)this._value).longValue();
        }
        if (this.isDouble()) {
            return ((Double)this._value).longValue();
        }
        if (this.isBoolean()) {
            return this.booleanValue() != false ? 1L : 0L;
        }
        if (this.isDateTime()) {
            OffsetDateTime dateTime = (OffsetDateTime)this._value;
            return dateTime.toEpochSecond();
        }
        if (this.isDate()) {
            LocalDate date = (LocalDate)this._value;
            return date.toEpochDay();
        }
        if (this.isTime()) {
            LocalTime time = (LocalTime)this._value;
            return time.toNanoOfDay();
        }
        throw new ExprValueException(Messages.getMessage("ExprValue.cannotCastToLong", this._value));
    }

    public Float floatValue() {
        if (this.isNull()) {
            throw new NullExprValueException(Messages.getMessage("ExprValue.cannotCastNull", new Object[]{ExprValueType.FLOAT}));
        }
        if (this.isBigDecimal()) {
            return Float.valueOf(this.bigDecimalValue().floatValue());
        }
        if (this.isBytes()) {
            return Float.valueOf(new BigInteger((byte[])this._value).floatValue());
        }
        if (this.isInteger()) {
            return Float.valueOf(((Integer)this._value).floatValue());
        }
        if (this.isLong()) {
            return Float.valueOf(((Long)this._value).floatValue());
        }
        if (this.isFloat()) {
            return (Float)this._value;
        }
        if (this.isDouble()) {
            return Float.valueOf(((Double)this._value).floatValue());
        }
        if (this.isString()) {
            ExprValue numericValue = this.convertStringOperandToNumericIfPossible();
            return numericValue.floatValue();
        }
        if (this.isBoolean()) {
            return Float.valueOf(this.booleanValue() != false ? 1.0f : 0.0f);
        }
        throw new ExprValueException(Messages.getMessage("ExprValue.cannotCastToFloat", this._value));
    }

    public Double doubleValue() {
        if (this.isNull()) {
            throw new NullExprValueException(Messages.getMessage("ExprValue.cannotCastNull", new Object[]{ExprValueType.DOUBLE}));
        }
        if (this.isBigDecimal()) {
            return this.bigDecimalValue().doubleValue();
        }
        if (this.isBytes()) {
            return new BigInteger((byte[])this._value).doubleValue();
        }
        if (this.isInteger()) {
            return ((Integer)this._value).doubleValue();
        }
        if (this.isLong()) {
            return ((Long)this._value).doubleValue();
        }
        if (this.isFloat()) {
            return ((Float)this._value).doubleValue();
        }
        if (this.isDouble()) {
            return (Double)this._value;
        }
        if (this.isString()) {
            ExprValue numericValue = this.convertStringOperandToNumericIfPossible();
            return numericValue.doubleValue();
        }
        if (this.isBoolean()) {
            return this.booleanValue() != false ? 1.0 : 0.0;
        }
        throw new ExprValueException(Messages.getMessage("ExprValue.cannotCastToDouble", this._value));
    }

    public String stringValue() {
        if (this.isNull()) {
            return "null";
        }
        if (this.isBigDecimal()) {
            return this.bigDecimalValue().toPlainString();
        }
        if (this.isInteger() || this.isLong() || this.isDouble() || this.isFloat() || this.isBoolean() || this.isDateTime() || this.isDate() || this.isTime()) {
            return this._value.toString();
        }
        if (this.isBytes()) {
            return ExprValueUtils.byteArrayToHexString((byte[])this._value);
        }
        return (String)this._value;
    }

    public Boolean booleanValue() {
        if (this.isNull()) {
            throw new NullExprValueException(Messages.getMessage("ExprValue.cannotCastNull", new Object[]{ExprValueType.BOOLEAN}));
        }
        if (this.isBigDecimal()) {
            return this.bigDecimalValue().signum() != 0;
        }
        if (this.isBytes()) {
            byte[] arrayValue = this.bytesValue();
            return ExprValueUtils.byteArrayToBooleanValue(arrayValue);
        }
        if (this.isInteger()) {
            return this.intValue() != 0;
        }
        if (this.isLong()) {
            return this.longValue() != 0L;
        }
        if (this.isFloat()) {
            return this.compare(this.floatValue().floatValue(), 0.0f) != 0;
        }
        if (this.isDouble()) {
            return this.compare(this.doubleValue(), 0.0) != 0;
        }
        if (this.isString()) {
            return Boolean.valueOf((String)this._value);
        }
        if (this.isBoolean()) {
            return (Boolean)this._value;
        }
        throw new ExprValueException(Messages.getMessage("ExprValue.cannotCastToBoolean", this._value));
    }

    public LocalDate dateValue() {
        if (this.isNull()) {
            throw new NullExprValueException(Messages.getMessage("ExprValue.cannotCastNull", new Object[]{ExprValueType.DATE}));
        }
        if (this.isString()) {
            return ExprValueUtils.parseToDate((String)this._value);
        }
        if (this.isDate()) {
            return (LocalDate)this._value;
        }
        if (this.isDateTime()) {
            OffsetDateTime dateTime = (OffsetDateTime)this._value;
            return dateTime.toLocalDate();
        }
        if (this.isLong()) {
            return ExprValueUtils.millsToLocalDate((Long)this._value);
        }
        if (this.isBytes()) {
            ByteBuffer bytevalue = ByteBuffer.wrap((byte[])this._value);
            return ExprValueUtils.millsToLocalDate(bytevalue.getLong());
        }
        throw new ExprValueException(Messages.getMessage("ExprValue.cannotCastToDate", this._value));
    }

    public OffsetDateTime dateTimeValue() {
        if (this.isNull()) {
            throw new NullExprValueException(Messages.getMessage("ExprValue.cannotCastNull", new Object[]{ExprValueType.DATETIME}));
        }
        if (this.isString()) {
            return ExprValueUtils.parseToDateTime((String)this._value);
        }
        if (this.isDateTime()) {
            return (OffsetDateTime)this._value;
        }
        if (this.isDate()) {
            LocalDate date = (LocalDate)this._value;
            ZoneOffset offset = ExprValueUtils.getOffset(date, LocalTime.MIDNIGHT);
            LocalDateTime noon = date.atTime(LocalTime.MIDNIGHT);
            return OffsetDateTime.of(noon, offset);
        }
        if (this.isLong()) {
            return ExprValueUtils.millsToLocalDateTime((Long)this._value);
        }
        if (this.isBytes()) {
            return ExprValueUtils.millsToLocalDateTime(new BigInteger((byte[])this._value).longValue());
        }
        throw new ExprValueException(Messages.getMessage("ExprValue.cannotCastToDateTime", this._value));
    }

    public LocalTime timeValue() {
        if (this.isNull()) {
            throw new NullExprValueException(Messages.getMessage("ExprValue.cannotCastNull", new Object[]{ExprValueType.TIME}));
        }
        if (this.isString()) {
            return ExprValueUtils.parseToTime((String)this._value);
        }
        if (this.isDateTime()) {
            OffsetDateTime dateTime = (OffsetDateTime)this._value;
            return dateTime.toLocalTime();
        }
        if (this.isTime()) {
            return (LocalTime)this._value;
        }
        throw new ExprValueException(Messages.getMessage("ExprValue.cannotCastToTime", this._value));
    }

    public boolean isBoolean() {
        return this._type == ExprValueType.BOOLEAN;
    }

    public boolean isBigDecimal() {
        return this._type == ExprValueType.BIGDECIMAL;
    }

    public boolean isBytes() {
        return this._type == ExprValueType.BYTES;
    }

    public boolean isDate() {
        return this._type == ExprValueType.DATE;
    }

    public boolean isDateTime() {
        return this._type == ExprValueType.DATETIME;
    }

    public boolean isDouble() {
        return this._type == ExprValueType.DOUBLE;
    }

    public boolean isInteger() {
        return this._type == ExprValueType.INTEGER;
    }

    public boolean isLong() {
        return this._type == ExprValueType.LONG;
    }

    public boolean isTime() {
        return this._type == ExprValueType.TIME;
    }

    public boolean isFloat() {
        return this._type == ExprValueType.FLOAT;
    }

    public boolean isString() {
        return this._type == ExprValueType.STRING;
    }

    public boolean isNull() {
        return this._type == ExprValueType.NULL;
    }

    public boolean isNumeric() {
        return this.isFloat() || this.isLong() || this.isInteger() || this.isDouble() || this.isBigDecimal();
    }

    public boolean isTemporal() {
        return this.isDate() || this.isTime() || this.isDateTime();
    }

    public boolean isType(ExprValueType ... types) {
        for (ExprValueType type : types) {
            if (type != this._type) continue;
            return true;
        }
        return false;
    }

    public boolean isNotType(ExprValueType ... types) {
        for (ExprValueType type : types) {
            if (type != this._type) continue;
            return false;
        }
        return true;
    }

    public Object getValue() {
        return this._value;
    }

    public ExprValueType getType() {
        return this._type;
    }

    public String toString() {
        if (this._type == ExprValueType.BYTES) {
            return ExprValueUtils.byteArrayToHexString((byte[])this._value) + ": " + this._type.name();
        }
        return this.stringValue() + ": " + this._type.name();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._type == null ? 0 : this._type.hashCode());
        result = 31 * result + (this._value == null ? 0 : this._value.hashCode());
        return result;
    }
}

