/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.interpreter.impl.function;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import org.talend.maplang.el.interpreter.Messages;
import org.talend.maplang.el.interpreter.api.ExprEvalVisitor;
import org.talend.maplang.el.interpreter.api.ExprLangContext;
import org.talend.maplang.el.interpreter.api.ExprLangFunction;
import org.talend.maplang.el.interpreter.impl.ExprValue;
import org.talend.maplang.el.interpreter.impl.ExprValueUtils;
import org.talend.maplang.el.interpreter.impl.function.ExprLangFunctionException;
import org.talend.maplang.el.interpreter.impl.function.TimeoutCharSequence;
import org.talend.maplang.el.parser.model.ELNode;

public abstract class AbstractExprLangFunction
implements ExprLangFunction {
    protected static final Class<?> RESULT_BOOLEAN_CLASS = Boolean.class;
    protected static final Class<?> RESULT_DOUBLE_CLASS = Double.class;
    protected static final Class<?> RESULT_FLOAT_CLASS = Float.class;
    protected static final Class<?>[] RESULT_FLOAT_CLASSES = new Class[]{RESULT_FLOAT_CLASS, RESULT_DOUBLE_CLASS};
    protected static final Class<?> RESULT_INTEGER_CLASS = Integer.class;
    protected static final Class<?> RESULT_LONG_CLASS = Long.class;
    protected static final Class<?>[] RESULT_INT_CLASSES = new Class[]{RESULT_INTEGER_CLASS, RESULT_LONG_CLASS};
    protected static final Class<?> RESULT_DECIMAL_CLASS = BigDecimal.class;
    protected static final Class<?> RESULT_STRING_CLASS = String.class;
    protected static final Class<?> RESULT_BYTES_CLASS = byte[].class;
    protected static final Class<?>[] RESULT_STRING_OR_BYTES_CLASSES = new Class[]{RESULT_STRING_CLASS, RESULT_BYTES_CLASS};
    protected static final Class<?>[] RESULT_NUMBER_CLASSES = new Class[]{RESULT_LONG_CLASS, RESULT_INTEGER_CLASS, RESULT_FLOAT_CLASS, RESULT_DECIMAL_CLASS, RESULT_DOUBLE_CLASS};
    protected static final Class<?> RESULT_DATE_CLASS = LocalDate.class;
    protected static final Class<?> RESULT_TIME_CLASS = LocalTime.class;
    protected static final Class<?> RESULT_DATETIME_CLASS = OffsetDateTime.class;
    protected static final Class<?>[] RESULT_ANY_CLASS = new Class[]{RESULT_BOOLEAN_CLASS, RESULT_DOUBLE_CLASS, RESULT_FLOAT_CLASS, RESULT_INTEGER_CLASS, RESULT_LONG_CLASS, RESULT_DECIMAL_CLASS, RESULT_STRING_CLASS, RESULT_BYTES_CLASS, RESULT_DATE_CLASS, RESULT_TIME_CLASS, RESULT_DATETIME_CLASS};
    private String _name;
    private static final int DEFAULT_TIMEOUT_MILLISECONDS = 10000;
    private Class<?> _resultClass = null;
    private Class<?>[] _resultClasses = null;
    private boolean isSingleClassResult = true;

    protected AbstractExprLangFunction(String name) {
        this._name = name;
    }

    protected AbstractExprLangFunction(String name, Class<?> resultClass) {
        this._name = name;
        this._resultClass = resultClass;
    }

    protected AbstractExprLangFunction(String name, Class<?>[] resultClasses) {
        this._name = name;
        this._resultClasses = resultClasses;
        this.isSingleClassResult = false;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public Object call(ExprLangContext context, Object ... parms) {
        return this.call(parms);
    }

    @Override
    public Class<?> getResultClass() {
        return this._resultClass;
    }

    @Override
    public Class<?>[] getResultClasses() {
        return this._resultClasses;
    }

    @Override
    public boolean isSingleClassResult() {
        return this.isSingleClassResult;
    }

    public abstract Object call(Object ... var1) throws ExprLangFunctionException;

    protected void checkNbrOfArguments(Object[] params, int size) {
        if (params.length != size) {
            throw new ExprLangFunctionException(Messages.getMessage("ExprLangFunction.invalidNbrOfArguments", this.getName(), size));
        }
    }

    protected void checkMinimalNbrOfArguments(Object[] params, int min) {
        if (params.length < min) {
            throw new ExprLangFunctionException(Messages.getMessage("ExprLangFunction.invalidMinimalNbrOfArguments", this.getName(), min));
        }
    }

    protected void checkMaximalNbrOfArguments(Object[] params, int max) {
        if (params.length > max) {
            throw new ExprLangFunctionException(Messages.getMessage("ExprLangFunction.invalidMaximalNbrOfArguments", this.getName(), max));
        }
    }

    protected void checkNbrOfArguments(Object[] params, int min, int max) {
        if (params.length < min || params.length > max) {
            throw new ExprLangFunctionException(Messages.getMessage("ExprLangFunction.nbrOfArgumentsNotValidInRange", this.getName(), min, max));
        }
    }

    protected void checkArgumentClass(Object[] params, int index, Class<?> expectedClass) {
        if (params[index] == null) {
            throw new ExprLangFunctionException(Messages.getMessage("ExprLangFunction.invalidArgumentNullClass", this.getName(), index + 1, expectedClass.getSimpleName()));
        }
        Object param = params[index];
        Class<?> paramClass = param.getClass();
        if (!expectedClass.isAssignableFrom(paramClass)) {
            throw new ExprLangFunctionException(Messages.getMessage("ExprLangFunction.invalidArgumentClass", this.getName(), index + 1, paramClass.getSimpleName(), expectedClass.getSimpleName()));
        }
    }

    protected void checkArgumentClass(Object[] params, int index, Class<?> ... expectedClasses) {
        this.checkArgumentNotNullByIndex(params, index);
        Object param = params[index];
        Class<?> paramClass = param.getClass();
        boolean valid = false;
        ArrayList<String> expectedClassNames = new ArrayList<String>();
        for (Class<?> expectedClass : expectedClasses) {
            valid = valid || expectedClass.isAssignableFrom(paramClass);
            expectedClassNames.add(expectedClass.getSimpleName());
        }
        if (!valid) {
            throw new ExprLangFunctionException(Messages.getMessage("ExprLangFunction.invalidArgumentClasses", this.getName(), index + 1, paramClass.getSimpleName(), String.join((CharSequence)",", expectedClassNames)));
        }
    }

    protected void checkArgumentsNotNull(Object[] params) {
        for (int index = 0; index < params.length; ++index) {
            this.checkArgumentNotNullByIndex(params, index);
        }
    }

    protected void checkArgumentNotNullByIndex(Object[] params, int index) {
        if (params[index] == null) {
            throw new ExprLangFunctionException(Messages.getMessage("ExprLangFunction.invalidArgumentNull", this.getName(), index + 1));
        }
    }

    protected void checkArgumentNotEmptyByIndex(Object[] params, int index) {
        if (params[index] instanceof String && ((String)params[index]).isEmpty()) {
            throw new ExprLangFunctionException(Messages.getMessage("ExprLangFunction.invalidArgumentEmpty", this.getName(), index + 1));
        }
    }

    protected void checkArgumentNotNullEmptyByIndex(Object[] params, int index) {
        this.checkArgumentNotNullByIndex(params, index);
        this.checkArgumentNotEmptyByIndex(params, index);
    }

    protected void checkInvalidNegativeIntArgumentByIndex(int inputValue, int index) {
        if (inputValue < 0) {
            throw new ExprLangFunctionException(Messages.getMessage("ExprLangFunction.invalidNegativeArg", this.getName(), index + 1));
        }
    }

    protected CharSequence getInput(int inputIndex, int timeoutIndex, Object ... parms) {
        this.checkArgumentNotNullByIndex(parms, inputIndex);
        String input = this.stringValue(parms[inputIndex]);
        if (parms.length > timeoutIndex) {
            this.checkArgumentClass(parms, timeoutIndex, Number.class, String.class, byte[].class);
            long timeout = this.exprValue(parms[timeoutIndex]).longValue();
            return new TimeoutCharSequence(input, timeout);
        }
        return new TimeoutCharSequence(input, 10000L);
    }

    protected void isBytesOrHexString(Object[] params, int index) {
        if (!(params[index] instanceof byte[]) && !ExprValueUtils.isHexStringCandidate(params[index])) {
            throw new ExprLangFunctionException(Messages.getMessage("ExprLangFunction.invalidArgumentBytes", this.getName(), index, params[index].getClass().getSimpleName()));
        }
    }

    protected ExprValue exprValue(Object value) {
        return new ExprValue(value);
    }

    protected String stringValue(Object arg) {
        return this.exprValue(arg).stringValue();
    }

    protected boolean booleanValue(Object arg) {
        return this.exprValue(arg).booleanValue();
    }

    protected Object[] evaluateArguments(ExprEvalVisitor evalVisitor, ELNode ... argNodes) {
        Object[] values = new Object[argNodes.length];
        for (int i = 0; i < argNodes.length; ++i) {
            values[i] = argNodes[i].accept(evalVisitor).getValue();
        }
        return values;
    }
}

