/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.interpreter.impl.function;

import java.lang.reflect.Method;
import org.talend.maplang.el.interpreter.impl.ExprValue;
import org.talend.maplang.el.interpreter.impl.function.ExprLangFunctionException;
import org.talend.maplang.el.interpreter.impl.function.JavaClassUtils;

public class JavaFunction {
    public static final String JAVA_CALL = "java:call";
    private final String _className;
    private final String _methodName;
    private final ClassLoader _cl;

    public static boolean isJavaFunction(String name) {
        return JAVA_CALL.equals(name);
    }

    public JavaFunction(String className, String methodName, ClassLoader cl) {
        this._className = className;
        this._methodName = methodName;
        this._cl = cl;
    }

    public ExprValue callStatic(ExprValue[] arguments) throws ExprLangFunctionException {
        Class<?> javaClass = this.getClass(this._className, this._cl);
        Object result = this.invokeStaticMethod(javaClass, this._methodName, this.getParameterValues(arguments));
        return new ExprValue(result);
    }

    public ExprValue call(ExprValue[] constructorArgs, ExprValue[] methodArgs) throws ExprLangFunctionException {
        Class<?> javaClass = this.getClass(this._className, this._cl);
        Object object = this.invokeConstructor(javaClass, this.getParameterValues(constructorArgs));
        Object result = this.invokeMethod(object, this._methodName, this.getParameterValues(methodArgs));
        return new ExprValue(result);
    }

    private Object[] getParameterValues(ExprValue[] arguments) {
        Object[] values = new Object[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            values[i] = arguments[i].getValue();
        }
        return values;
    }

    private Class<?> getClass(String className, ClassLoader cl) {
        try {
            return Class.forName(className, true, cl);
        }
        catch (ClassNotFoundException e) {
            throw new ExprLangFunctionException(e);
        }
    }

    private Object invokeStaticMethod(Class<?> javaClass, String methodName, Object[] parameterValues) {
        try {
            Method m = JavaClassUtils.getMethod(javaClass, methodName, parameterValues);
            return m.invoke(null, JavaClassUtils.toVarArgs(m, parameterValues));
        }
        catch (Exception e) {
            throw new ExprLangFunctionException(e);
        }
    }

    private Object invokeMethod(Object javaClass, String methodName, Object[] parameterValues) {
        try {
            Method m = JavaClassUtils.getMethod(javaClass.getClass(), methodName, parameterValues);
            return m.invoke(javaClass, JavaClassUtils.toVarArgs(m, parameterValues));
        }
        catch (Exception e) {
            throw new ExprLangFunctionException(e);
        }
    }

    private Object invokeConstructor(Class<?> javaClass, Object[] parameterValues) {
        try {
            return JavaClassUtils.getConstructor(javaClass, parameterValues).newInstance(parameterValues);
        }
        catch (Exception e) {
            throw new ExprLangFunctionException(e);
        }
    }
}

