/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.interpreter.impl.function.builtin;

import java.math.BigDecimal;
import org.talend.maplang.el.interpreter.impl.ExprValue;
import org.talend.maplang.el.interpreter.impl.function.AbstractExprLangFunction;
import org.talend.maplang.el.interpreter.impl.function.ExprLangFunctionException;

public class Absolute
extends AbstractExprLangFunction {
    public static final String NAME = "abs";

    public Absolute() {
        super(NAME, RESULT_NUMBER_CLASSES);
    }

    @Override
    public Object call(Object ... parms) throws ExprLangFunctionException {
        this.checkNbrOfArguments(parms, 1);
        this.checkArgumentClass(parms, 0, (Class<?>)Number.class);
        ExprValue arg = this.exprValue(parms[0]);
        if (arg.isLong()) {
            return Math.abs((Long)parms[0]);
        }
        if (arg.isInteger()) {
            return Math.abs((Integer)parms[0]);
        }
        if (arg.isFloat()) {
            return Float.valueOf(Math.abs(((Float)parms[0]).floatValue()));
        }
        if (arg.isBigDecimal()) {
            return ((BigDecimal)parms[0]).abs();
        }
        return Math.abs(arg.doubleValue());
    }
}

