/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.interpreter.impl.function.builtin;

import java.time.LocalDate;
import java.time.OffsetDateTime;
import org.talend.maplang.el.interpreter.Messages;
import org.talend.maplang.el.interpreter.impl.ExprValueException;
import org.talend.maplang.el.interpreter.impl.function.AbstractExprLangFunction;
import org.talend.maplang.el.interpreter.impl.function.ExprLangFunctionException;

public abstract class AbstractIsDateFunction
extends AbstractExprLangFunction {
    protected AbstractIsDateFunction(String name) {
        super(name, RESULT_BOOLEAN_CLASS);
    }

    @Override
    public Object call(Object ... parms) throws ExprLangFunctionException {
        this.checkNbrOfArguments(parms, 1);
        this.checkArgumentClass(parms, 0, String.class, OffsetDateTime.class, LocalDate.class);
        Object arg = parms[0];
        if (arg instanceof String) {
            LocalDate dateValue = null;
            try {
                dateValue = this.exprValue(arg).dateValue();
            }
            catch (ExprValueException e) {
                throw new ExprLangFunctionException(Messages.getMessage("ExprLangFunction.functionCallError", this.getName(), e.getMessage()));
            }
            arg = dateValue;
        }
        if (arg instanceof LocalDate) {
            return this.checkDate((LocalDate)arg);
        }
        return this.checkDateTime((OffsetDateTime)arg);
    }

    protected abstract boolean checkDate(LocalDate var1);

    protected abstract boolean checkDateTime(OffsetDateTime var1);
}

