/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.interpreter.impl.function.builtin;

import java.time.LocalDate;
import java.time.OffsetDateTime;
import org.talend.maplang.el.interpreter.ExprInterpreterConstants;
import org.talend.maplang.el.interpreter.Messages;
import org.talend.maplang.el.interpreter.impl.function.AbstractExprLangFunction;
import org.talend.maplang.el.interpreter.impl.function.ExprLangFunctionException;

public class AddToDateTime
extends AbstractExprLangFunction {
    public static final String NAME = "addToDateTime";

    public AddToDateTime() {
        super(NAME, RESULT_DATETIME_CLASS);
    }

    @Override
    public Object call(Object ... parms) throws ExprLangFunctionException {
        this.checkNbrOfArguments(parms, 3);
        this.checkArgumentClass(parms, 0, (Class<?>)String.class);
        this.checkArgumentClass(parms, 1, String.class, Number.class, byte[].class);
        this.checkArgumentClass(parms, 2, OffsetDateTime.class, LocalDate.class, String.class);
        String what = parms[0].toString();
        Long amount = this.exprValue(parms[1]).longValue();
        OffsetDateTime dateTime = this.exprValue(parms[2]).dateTimeValue();
        ExprInterpreterConstants.DateTimeConstantType valueWhat = ExprInterpreterConstants.DateTimeConstantType.getType(what);
        try {
            switch (valueWhat) {
                case YEAR: {
                    return dateTime.plusYears(amount);
                }
                case MONTH: {
                    return dateTime.plusMonths(amount);
                }
                case WEEK: {
                    return dateTime.plusWeeks(amount);
                }
                case DAY: {
                    return dateTime.plusDays(amount);
                }
                case HOUR: {
                    return dateTime.plusHours(amount);
                }
                case MINUTE: {
                    return dateTime.plusMinutes(amount);
                }
                case SECOND: {
                    return dateTime.plusSeconds(amount);
                }
                case MILLISECOND: {
                    long nanos = amount * 1000000L;
                    return dateTime.plusNanos(nanos);
                }
            }
            throw new ExprLangFunctionException(Messages.getMessage("ExprValue.NotSupportedDateTimeType", what));
        }
        catch (Exception ex) {
            throw new ExprLangFunctionException(Messages.getMessage("ExprFunction.invalidDateTimeOperation", new Object[0]));
        }
    }
}

