/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.interpreter.impl.function.builtin;

import org.talend.maplang.el.interpreter.impl.function.AbstractExprLangFunction;
import org.talend.maplang.el.interpreter.impl.function.ExprLangFunctionException;

public class Contains
extends AbstractExprLangFunction {
    public static final String NAME = "contains";

    public Contains() {
        super(NAME, RESULT_BOOLEAN_CLASS);
    }

    @Override
    public Object call(Object ... parms) throws ExprLangFunctionException {
        this.checkNbrOfArguments(parms, 2, 3);
        this.checkArgumentClass(parms, 0, String.class, Number.class, byte[].class, Boolean.class);
        this.checkArgumentClass(parms, 1, String.class, Number.class, byte[].class, Boolean.class);
        if (parms.length > 2) {
            this.checkArgumentClass(parms, 2, String.class, Number.class, byte[].class, Boolean.class);
        }
        if (parms[0] instanceof byte[]) {
            this.isBytesOrHexString(parms, 1);
        } else {
            this.checkArgumentsNotNull(parms);
        }
        return this.contains(parms);
    }

    private boolean contains(Object ... parms) {
        boolean ignoreCase;
        String str = this.stringValue(parms[0]);
        String subStr = this.stringValue(parms[1]);
        if (parms[0] instanceof byte[]) {
            int index = str.indexOf(subStr = subStr.substring(2).toUpperCase());
            return index % 2 == 0;
        }
        if (parms.length > 2 && (ignoreCase = this.booleanValue(parms[2]))) {
            return str.toLowerCase().contains(subStr.toLowerCase());
        }
        return str.contains(subStr);
    }
}

