/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.interpreter.impl.function.builtin;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.Calendar;
import java.util.TimeZone;
import org.talend.maplang.el.interpreter.impl.function.builtin.AbstractIsDateFunction;

public class IsTomorrow
extends AbstractIsDateFunction {
    public static final String NAME = "isTomorrow";

    public IsTomorrow() {
        super(NAME);
    }

    @Override
    protected boolean checkDate(LocalDate date) {
        return LocalDate.now().plusDays(1L).compareTo(date) == 0;
    }

    @Override
    protected boolean checkDateTime(OffsetDateTime dateTime) {
        TimeZone tz = Calendar.getInstance().getTimeZone();
        LocalDateTime ldt = LocalDateTime.ofInstant(dateTime.toInstant(), tz.toZoneId());
        return ldt.toLocalDate().compareTo(LocalDate.now(tz.toZoneId()).plusDays(1L)) == 0;
    }
}

