/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.interpreter.impl.function.builtin;

import java.math.BigDecimal;
import org.talend.maplang.el.interpreter.impl.ExprValue;
import org.talend.maplang.el.interpreter.impl.function.AbstractExprLangFunction;
import org.talend.maplang.el.interpreter.impl.function.ExprLangFunctionException;

public class Max
extends AbstractExprLangFunction {
    public static final String NAME = "max";

    public Max() {
        super(NAME, RESULT_NUMBER_CLASSES);
    }

    @Override
    public Object call(Object ... parms) throws ExprLangFunctionException {
        this.checkNbrOfArguments(parms, 2);
        this.checkArgumentClass(parms, 0, (Class<?>)Number.class);
        this.checkArgumentClass(parms, 1, (Class<?>)Number.class);
        return Max.getResult(this.exprValue(parms[0]), this.exprValue(parms[1]));
    }

    public static Object getResult(ExprValue value, ExprValue value2) {
        if (value.isBigDecimal() || value2.isBigDecimal()) {
            BigDecimal val2;
            BigDecimal val = value.bigDecimalValue();
            return val.compareTo(val2 = value2.bigDecimalValue()) >= 0 ? val : val2;
        }
        if (value.isDouble() || value2.isDouble()) {
            return Math.max(value.doubleValue(), value2.doubleValue());
        }
        if (value.isFloat() || value2.isFloat()) {
            return Float.valueOf(Math.max(value.floatValue().floatValue(), value2.floatValue().floatValue()));
        }
        if (value.isLong() || value2.isLong()) {
            return Math.max(value.longValue(), value2.longValue());
        }
        return Math.max(value.intValue(), value2.intValue());
    }
}

