/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.interpreter.impl.function.builtin;

import java.math.BigDecimal;
import org.talend.maplang.el.interpreter.impl.ExprValue;
import org.talend.maplang.el.interpreter.impl.function.AbstractExprLangFunction;
import org.talend.maplang.el.interpreter.impl.function.ExprLangFunctionException;

public class Min
extends AbstractExprLangFunction {
    public static final String NAME = "min";

    public Min() {
        super(NAME, RESULT_NUMBER_CLASSES);
    }

    @Override
    public Object call(Object ... parms) throws ExprLangFunctionException {
        this.checkNbrOfArguments(parms, 2);
        this.checkArgumentClass(parms, 0, (Class<?>)Number.class);
        this.checkArgumentClass(parms, 1, (Class<?>)Number.class);
        return Min.getResult(this.exprValue(parms[0]), this.exprValue(parms[1]));
    }

    public static Object getResult(ExprValue value, ExprValue value2) {
        if (value.isBigDecimal() || value2.isBigDecimal()) {
            BigDecimal val2;
            BigDecimal val = value.bigDecimalValue();
            return val.compareTo(val2 = value2.bigDecimalValue()) >= 0 ? val2 : val;
        }
        if (value.isDouble() || value2.isDouble() || value.isBigDecimal() || value2.isBigDecimal()) {
            return Math.min(value.doubleValue(), value2.doubleValue());
        }
        if (value.isFloat() || value2.isFloat()) {
            return Float.valueOf(Math.min(value.floatValue().floatValue(), value2.floatValue().floatValue()));
        }
        if (value.isLong() || value2.isLong()) {
            return Math.min(value.longValue(), value2.longValue());
        }
        return Math.min(value.intValue(), value2.intValue());
    }
}

