/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.interpreter.impl.function.builtin;

import org.talend.maplang.el.interpreter.impl.function.AbstractExprLangFunction;
import org.talend.maplang.el.interpreter.impl.function.ExprLangFunctionException;

public class NormalizeSpace
extends AbstractExprLangFunction {
    public static final String NAME = "normalizeSpace";

    public NormalizeSpace() {
        super(NAME, RESULT_STRING_CLASS);
    }

    @Override
    public Object call(Object ... parms) throws ExprLangFunctionException {
        this.checkNbrOfArguments(parms, 1);
        this.checkArgumentClass(parms, 0, (Class<?>)String.class);
        String value = parms[0].toString();
        return NormalizeSpace.normalize(value);
    }

    public static String normalize(String value) {
        StringBuffer sb = new StringBuffer();
        int len = value.length();
        boolean inWhitespace = true;
        block3: for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (inWhitespace) continue block3;
                    sb.append(' ');
                    inWhitespace = true;
                    continue block3;
                }
                default: {
                    sb.append(c);
                    inWhitespace = false;
                }
            }
        }
        int nlen = sb.length();
        if (nlen > 0 && sb.charAt(nlen - 1) == ' ') {
            sb.setLength(nlen - 1);
        }
        return sb.toString();
    }
}

