/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.interpreter.impl.function.builtin;

import org.talend.maplang.el.interpreter.api.CustomOpFunction;
import org.talend.maplang.el.interpreter.impl.ExprValueException;
import org.talend.maplang.el.interpreter.impl.function.AbstractExprLangFunction;
import org.talend.maplang.el.interpreter.impl.function.ExprLangFunctionException;
import org.talend.maplang.el.interpreter.impl.function.builtin.Between;

public class NotBetween
extends AbstractExprLangFunction
implements CustomOpFunction {
    public static final String NAME = "notbetween";
    public static final String[] OPERATORS = new String[]{"not between", "and"};

    public NotBetween() {
        super(NAME, RESULT_BOOLEAN_CLASS);
    }

    @Override
    public CustomOpFunction.Kind getKind() {
        return CustomOpFunction.Kind.TERNARY;
    }

    @Override
    public String getOperator(int position) {
        return OPERATORS[position];
    }

    @Override
    public Object call(Object ... parms) throws ExprLangFunctionException {
        this.checkNbrOfArguments(parms, 3);
        Boolean result = null;
        try {
            result = !Between.between(parms[0], parms[1], parms[2]);
        }
        catch (ExprValueException e) {
            throw new ExprLangFunctionException(e.getMessage());
        }
        return result;
    }

    @Override
    public boolean isVisible() {
        return false;
    }
}

