/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.interpreter.impl.function.builtin;

import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import org.talend.maplang.el.interpreter.impl.function.AbstractExprLangFunction;
import org.talend.maplang.el.interpreter.impl.function.ExprLangFunctionException;

public class ParseDateTime
extends AbstractExprLangFunction {
    public static final String NAME = "parseDateTime";

    public ParseDateTime() {
        super(NAME, RESULT_DATETIME_CLASS);
    }

    @Override
    public Object call(Object ... parms) throws ExprLangFunctionException {
        this.checkNbrOfArguments(parms, 2);
        this.checkArgumentClass(parms, 0, (Class<?>)String.class);
        this.checkArgumentClass(parms, 1, (Class<?>)String.class);
        String inputValue = parms[0].toString();
        String pattern = parms[1].toString();
        DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern(pattern).parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).parseDefaulting(ChronoField.NANO_OF_SECOND, 0L).parseDefaulting(ChronoField.OFFSET_SECONDS, 0L).toFormatter();
        OffsetDateTime o = OffsetDateTime.parse(inputValue, formatter);
        return o;
    }
}

