/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.interpreter.impl.function.builtin;

import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import org.talend.maplang.el.interpreter.Messages;
import org.talend.maplang.el.interpreter.impl.function.AbstractExprLangFunction;
import org.talend.maplang.el.interpreter.impl.function.ExprLangFunctionException;

public class ToString
extends AbstractExprLangFunction {
    public static final String NAME = "toString";

    public ToString() {
        super(NAME, RESULT_STRING_CLASS);
    }

    @Override
    public Object call(Object ... parms) throws ExprLangFunctionException {
        this.checkArguments(parms);
        if (this.exprValue(parms[0]).isTemporal() && parms.length == 2) {
            this.checkArgumentClass(parms, 1, (Class<?>)String.class);
            try {
                return this.getDateTimeStringValue(parms);
            }
            catch (Exception e) {
                throw new ExprLangFunctionException(Messages.getMessage("ExprLangFunction.unsupportedPattern", this.getName(), e.getMessage()));
            }
        }
        return this.stringValue(parms[0]);
    }

    private void checkArguments(Object ... parms) {
        this.checkMaximalNbrOfArguments(parms, 2);
        if (parms.length == 2) {
            this.checkArgumentClass(parms, 0, (Class<?>)Temporal.class);
            this.checkArgumentClass(parms, 1, (Class<?>)String.class);
            this.checkArgumentNotNullEmptyByIndex(parms, 1);
        }
    }

    private String getDateTimeStringValue(Object ... parms) {
        String pattern = (String)parms[1];
        DateTimeFormatter outputFormat = DateTimeFormatter.ofPattern(pattern);
        if (this.exprValue(parms[0]).isDate() && !this.isSimpleTimeFormat(outputFormat)) {
            return outputFormat.format(this.exprValue(parms[0]).dateTimeValue());
        }
        return outputFormat.format((TemporalAccessor)parms[0]);
    }

    private boolean isSimpleTimeFormat(DateTimeFormatter outputFormat) {
        OffsetTime time = OffsetTime.now();
        try {
            outputFormat.format(time);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

