/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.interpreter.impl.function.builtin;

import org.talend.maplang.el.interpreter.impl.function.AbstractExprLangFunction;
import org.talend.maplang.el.interpreter.impl.function.ExprLangFunctionException;

public class Translate
extends AbstractExprLangFunction {
    public static final String NAME = "translate";

    public Translate() {
        super(NAME, RESULT_STRING_CLASS);
    }

    @Override
    public Object call(Object ... parms) throws ExprLangFunctionException {
        this.checkNbrOfArguments(parms, 3);
        this.checkArgumentsNotNull(parms);
        this.checkArgumentClass(parms, 0, String.class, Number.class, byte[].class, Boolean.class);
        this.checkArgumentClass(parms, 1, String.class, Number.class, byte[].class, Boolean.class);
        this.checkArgumentClass(parms, 2, String.class, Number.class, byte[].class, Boolean.class);
        String input = this.stringValue(parms[0]);
        String toBeReplaced = this.stringValue(parms[1]);
        String replacement = this.stringValue(parms[2]);
        return this.translate(input, toBeReplaced, replacement);
    }

    protected String translate(String input, String source, String target) {
        int inputIndex;
        if (source.isEmpty()) {
            return input;
        }
        char[] inputChars = input.toCharArray();
        int size = inputChars.length;
        char[] charactersToBeReplaced = source.toCharArray();
        char[] replacementCharacters = target.toCharArray();
        char[] outputChars = new char[size];
        int outputIndex = 0;
        for (inputIndex = 0; inputIndex < size; ++inputIndex) {
            char inputChar = inputChars[inputIndex];
            Character outputChar = this.replaceChar(inputChar, charactersToBeReplaced, replacementCharacters);
            if (outputChar == null) continue;
            outputChars[outputIndex] = outputChar.charValue();
            ++outputIndex;
        }
        if (outputIndex < inputIndex) {
            char[] result = new char[outputIndex];
            System.arraycopy(outputChars, 0, result, 0, outputIndex);
            return String.valueOf(result);
        }
        return String.valueOf(outputChars);
    }

    protected Character replaceChar(char inputChar, char[] sourceChars, char[] targetChars) {
        Character outputChar = Character.valueOf(inputChar);
        for (int i = 0; i < sourceChars.length; ++i) {
            if (inputChar != sourceChars[i]) continue;
            outputChar = targetChars.length <= i ? null : Character.valueOf(targetChars[i]);
        }
        return outputChar;
    }
}

