/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.talend.maplang.el.parser.DslEscapeUtils;
import org.talend.maplang.el.parser.Location;

public class DslContent {
    private static final String EMPTY_CONTENT = "";
    private String originalContent;
    private String escapedContent;
    private Map<Integer, List<EscUniChar>> escapeInfo;

    public DslContent() {
        this(EMPTY_CONTENT);
    }

    public DslContent(String originalContent) {
        this.originalContent = originalContent;
    }

    public String getOriginalContent() {
        return this.originalContent;
    }

    public boolean isEscaped() {
        return this.escapeInfo != null;
    }

    public String getEscapedContent() {
        return this.escapedContent;
    }

    public String getParsedContent() {
        return this.escapeInfo != null ? this.escapedContent : this.originalContent;
    }

    private Map<Integer, List<EscUniChar>> getEscapeInfo() {
        if (this.escapeInfo == null) {
            this.escapeInfo = new HashMap<Integer, List<EscUniChar>>();
        }
        return this.escapeInfo;
    }

    public void escape() {
        if (this.escapedContent != null) {
            return;
        }
        String result = DslEscapeUtils.escape(this.originalContent, new DslEscapeUtils.DslEscapeListener(){

            @Override
            public void onCharacterEscaped(char character, int line, int column) {
                DslContent.this.onCharacterEscaped(line, column);
            }
        });
        this.setEscapedContent(result);
    }

    private void onCharacterEscaped(int line, int column) {
        Map<Integer, List<EscUniChar>> escInfo = this.getEscapeInfo();
        List<EscUniChar> escUniChars = escInfo.get(line);
        if (escUniChars == null) {
            escUniChars = new ArrayList<EscUniChar>();
            escInfo.put(line, escUniChars);
        }
        int offset = escUniChars.size() * 5;
        EscUniChar escUniChar = new EscUniChar(column + offset + 5);
        escUniChars.add(escUniChar);
    }

    private void setEscapedContent(String escapedContent) {
        this.escapedContent = escapedContent;
    }

    public Location adapt(Location location) {
        if (this.escapeInfo != null) {
            int column = location.getColumn();
            List<EscUniChar> escUniChars = this.escapeInfo.get(location.getLine());
            if (escUniChars != null) {
                int count = 0;
                for (EscUniChar escUniChar : escUniChars) {
                    if (column < escUniChar.getEscapedEnd()) break;
                    ++count;
                }
                if (count > 0) {
                    int adaptedColumn = column - count * 5;
                    return new Location(location.getLine(), adaptedColumn);
                }
            }
        }
        return location;
    }

    private static class EscUniChar {
        private int escapedEnd;

        public EscUniChar(int escapedEnd) {
            this.escapedEnd = escapedEnd;
        }

        public int getEscapedEnd() {
            return this.escapedEnd;
        }
    }
}

