/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.parser;

public class DslEscapeUtils {
    public static final int ESCAPED_UNICODE_CHAR_LENGTH = 5;
    public static final String ALPHANUMERIC_CHARACTERS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    public static final String SUPPORTED_CHARACTERS_IN_HPATH = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_$@#";
    public static final String SUPPORTED_CHARACTERS_IN_DSQL_SCRIPT = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_$@#/-*+%(){}[]:,.;&<>=!|\\'\"\r\n\t ";
    public static final char BACK_SLASH = '\\';
    public static final char BACK_TICK = '`';
    public static final char NEW_LINE_CHAR = '\n';
    public static final String ESCAPE_CHAR = "\\u";
    public static final char SLASH = '/';
    public static final char STAR = '*';
    public static final char SINGLE_QUOTE = '\'';
    public static final char DOUBLE_QUOTE = '\"';

    public static boolean isEscaped(String value) {
        return value.indexOf(ESCAPE_CHAR) >= 0;
    }

    public static String escapeFieldName(String value) {
        StringBuilder buf = new StringBuilder();
        int length = value.length();
        for (int index = 0; index < length; ++index) {
            char character = value.charAt(index);
            if (DslEscapeUtils.isSupportedCharacterInHPath(character)) {
                buf.append(character);
                continue;
            }
            String unicode = DslEscapeUtils.toUnicode(character);
            buf.append(unicode);
        }
        return buf.toString();
    }

    private static String escapeAll(String value) {
        StringBuilder buf = new StringBuilder();
        int length = value.length();
        for (int index = 0; index < length; ++index) {
            char character = value.charAt(index);
            buf.append(DslEscapeUtils.toUnicode(character));
        }
        return buf.toString();
    }

    public static String escapeInputName(String value) {
        boolean escapeAll = false;
        int length = value.length();
        for (int index = 0; index < length; ++index) {
            char character = value.charAt(index);
            if (!DslEscapeUtils.isSupportedCharacterInDsql(character) || DslEscapeUtils.isSupportedCharacterInHPath(character)) continue;
            escapeAll = true;
            break;
        }
        return escapeAll ? DslEscapeUtils.escapeAll(value) : DslEscapeUtils.escapeFieldName(value);
    }

    public static boolean isSupportedCharacterInDsql(char character) {
        return SUPPORTED_CHARACTERS_IN_DSQL_SCRIPT.indexOf(character) >= 0;
    }

    public static boolean isSupportedCharacterInHPath(char character) {
        return SUPPORTED_CHARACTERS_IN_HPATH.indexOf(character) >= 0;
    }

    public static String toUnicode(char character) {
        return ESCAPE_CHAR + Integer.toHexString(character | 0x10000).substring(1);
    }

    public static String escape(String value) {
        return DslEscapeUtils.escape(value, null);
    }

    public static String escape(String value, DslEscapeListener listener) {
        EscapeContext ctx = new EscapeContext(value);
        while (ctx.hasNextChar()) {
            ctx.readNextChar();
            if (ctx.character == '\n') {
                ctx.newLine();
                continue;
            }
            if (ctx.lineComment) {
                ctx.consume();
                continue;
            }
            if (ctx.blockComment) {
                if (ctx.character == '/' && ctx.prevChar == '*') {
                    ctx.blockComment = false;
                }
                ctx.consume();
                continue;
            }
            if (ctx.singleQuoteString) {
                if (ctx.character == '\'' && ctx.prevChar != '\\') {
                    ctx.singleQuoteString = false;
                }
                ctx.consume();
                continue;
            }
            if (ctx.doubleQuoteString) {
                if (ctx.character == '\"' && ctx.prevChar != '\\') {
                    ctx.doubleQuoteString = false;
                }
                ctx.consume();
                continue;
            }
            if (ctx.inBackTicks) {
                if (ctx.character == '`') {
                    ctx.inBackTicks = false;
                } else {
                    DslEscapeUtils.escape(ctx, listener);
                }
                ctx.next();
                continue;
            }
            if (ctx.character == '*' && ctx.prevChar == '/') {
                ctx.blockComment = true;
                ctx.consume();
                continue;
            }
            if (ctx.character == '/' && ctx.prevChar == '/') {
                ctx.lineComment = true;
                ctx.consume();
                continue;
            }
            if (ctx.character == '\'') {
                ctx.singleQuoteString = true;
                ctx.consume();
                continue;
            }
            if (ctx.character == '\"') {
                ctx.doubleQuoteString = true;
                ctx.consume();
                continue;
            }
            if (ctx.character == '`') {
                ctx.inBackTicks = true;
                ctx.next();
                continue;
            }
            if (DslEscapeUtils.isSupportedCharacterInDsql(ctx.character)) {
                ctx.consume();
                continue;
            }
            DslEscapeUtils.escape(ctx, listener);
            ctx.next();
        }
        return ctx.getResult();
    }

    private static void escape(EscapeContext context, DslEscapeListener listener) {
        String unicode = DslEscapeUtils.toUnicode(context.character);
        context.append(unicode);
        DslEscapeUtils.notify(listener, context.character, context.line, context.column);
    }

    private static void notify(DslEscapeListener listener, char character, int line, int column) {
        if (listener != null) {
            listener.onCharacterEscaped(character, line, column);
        }
    }

    public static String unescape(String value) {
        if (value.indexOf(ESCAPE_CHAR) >= 0) {
            StringBuilder buf = new StringBuilder();
            int length = value.length();
            int currentIndex = 0;
            int previousIndex = 0;
            while (currentIndex < length) {
                currentIndex = value.indexOf(ESCAPE_CHAR, previousIndex);
                if (currentIndex > previousIndex) {
                    buf.append(value.substring(previousIndex, currentIndex));
                }
                if (currentIndex >= 0) {
                    String hexCode = value.substring(currentIndex + 2, currentIndex + 6);
                    int hexVal = Integer.parseInt(hexCode, 16);
                    buf.append((char)hexVal);
                    previousIndex = currentIndex + 6;
                    continue;
                }
                buf.append(value.substring(previousIndex));
                break;
            }
            return buf.toString();
        }
        return value;
    }

    public static interface DslEscapeListener {
        public void onCharacterEscaped(char var1, int var2, int var3);
    }

    private static class EscapeContext {
        StringBuilder buf = null;
        String value = null;
        int length = 0;
        int index = 0;
        int line = 1;
        int column = 1;
        char prevChar = '\u0000';
        char character = '\u0000';
        boolean inBackTicks = false;
        boolean lineComment = false;
        boolean blockComment = false;
        boolean singleQuoteString = false;
        boolean doubleQuoteString = false;

        public EscapeContext(String value) {
            this.value = value;
            this.length = value.length();
            this.buf = new StringBuilder();
        }

        boolean hasNextChar() {
            return this.index < this.length;
        }

        void readNextChar() {
            this.character = this.value.charAt(this.index);
        }

        void newLine() {
            this.buf.append(this.character);
            this.column = 1;
            ++this.index;
            ++this.line;
            if (this.lineComment) {
                this.lineComment = false;
            }
            this.prevChar = this.character;
        }

        void consume() {
            this.buf.append(this.character);
            this.next();
        }

        void next() {
            ++this.index;
            ++this.column;
            this.prevChar = this.character;
        }

        void append(String val) {
            this.buf.append(val);
        }

        String getResult() {
            return this.buf.toString();
        }
    }
}

