/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.parser;

import java.io.StringReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.maplang.el.parser.CustomOperators;
import org.talend.maplang.el.parser.DSLException;
import org.talend.maplang.el.parser.DSLFunctions;
import org.talend.maplang.el.parser.DslContent;
import org.talend.maplang.el.parser.ExprLangException;
import org.talend.maplang.el.parser.ExprLangParser;
import org.talend.maplang.el.parser.Messages;
import org.talend.maplang.el.parser.ParseException;
import org.talend.maplang.el.parser.ParserErrorMessageProvider;
import org.talend.maplang.el.parser.internal.ELParserErrorMessageProvider;
import org.talend.maplang.el.parser.internal.ParseExceptionDetails;
import org.talend.maplang.el.parser.internal.ParsingContext;
import org.talend.maplang.el.parser.model.BaseExprModelVisitor;
import org.talend.maplang.el.parser.model.ELNode;
import org.talend.maplang.el.parser.model.ELNodeType;

public class ExprParser {
    private static final Logger LOG = LoggerFactory.getLogger(ExprParser.class);
    private ParserErrorMessageProvider errorMessageProvider;
    private boolean arraysAllowed = false;
    private DSLFunctions dslFunctions;
    private CustomOperators customOperators;

    public ExprParser() {
    }

    public ExprParser(ParserErrorMessageProvider errorMessageProvider) {
        this.errorMessageProvider = errorMessageProvider;
    }

    public void setDslFunctions(DSLFunctions dslFunctions) {
        this.dslFunctions = dslFunctions;
    }

    public void setCustomOperators(CustomOperators customOperators) {
        this.customOperators = customOperators;
    }

    public boolean isArraysAllowed() {
        return this.arraysAllowed;
    }

    public void setArraysAllowed(boolean arraysAllowed) {
        this.arraysAllowed = arraysAllowed;
    }

    private String getErrorMessage(ParseExceptionDetails exceptionDetails, ParsingContext parsingContext, DslContent dslContent) {
        if (this.errorMessageProvider == null) {
            this.errorMessageProvider = new ELParserErrorMessageProvider();
        }
        return this.errorMessageProvider.getErrorMessage(exceptionDetails, parsingContext, dslContent);
    }

    public ELNode parse(String expression) throws ExprLangException {
        return this.parseExpr(expression, new InternalParser(){

            @Override
            public ELNode parse(ExprLangParser parser) throws ParseException {
                return parser.parse();
            }
        });
    }

    public ELNode parseValueExpr(String expression) throws ExprLangException {
        return this.parseExpr(expression, new InternalParser(){

            @Override
            public ELNode parse(ExprLangParser parser) throws ParseException {
                ELNode model = new ELNode(ELNodeType.ROOT);
                parser.valueExpr(model);
                return model;
            }
        });
    }

    private ELNode parseExpr(String expression, InternalParser internalParser) throws ExprLangException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parse EL expression: " + expression);
        }
        DslContent dslContent = new DslContent(expression);
        dslContent.escape();
        ExprLangParser parser = new ExprLangParser(new StringReader(dslContent.getParsedContent()));
        ParsingContext parsingContext = new ParsingContext();
        if (this.dslFunctions != null) {
            parsingContext.setDslFunctions(this.dslFunctions);
        }
        if (this.customOperators != null) {
            parsingContext.setCustomOperators(this.customOperators);
        }
        parser.setParsingContext(parsingContext);
        parser.setDslContent(dslContent);
        ELNode model = null;
        try {
            model = internalParser.parse(parser);
        }
        catch (ParseException e) {
            throw new ExprLangException(this.getErrorMessage(parser.getExceptionDetails(e), parser.getParsingContext(), dslContent));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Generated EL model: " + model.toString());
        }
        try {
            this.validate(model);
        }
        catch (DSLException e) {
            throw ExprLangException.adapt(e);
        }
        return model;
    }

    private void validate(ELNode model) {
        BaseExprModelVisitor<Boolean> visitor = new BaseExprModelVisitor<Boolean>(BaseExprModelVisitor.ConditionalExprVisitPolicy.ALL){

            @Override
            protected Boolean mergeValues(Boolean value1, Boolean value2) {
                return false;
            }

            @Override
            protected Boolean getDefaultValue() {
                return false;
            }

            @Override
            public Boolean visitArray(ELNode arrayNode) {
                if (ExprParser.this.isArraysAllowed()) {
                    return (Boolean)this.visitChildren(arrayNode);
                }
                ExprLangException e = new ExprLangException(Messages.getMessage("ExprParserError.arrayNotSupported", new Object[0]), this.getDslContent(), arrayNode.getBeginLocation());
                throw e;
            }

            @Override
            public Boolean visitFunctionCall(ELNode functionNode) {
                String functionName = functionNode.getImage();
                if (ExprParser.this.dslFunctions != null && ExprParser.this.dslFunctions.isExtendedFunction(functionName)) {
                    ExprParser.this.dslFunctions.validateArguments(this.getDslContent(), functionName, functionNode);
                    return false;
                }
                return (Boolean)super.visitFunctionCall(functionNode);
            }
        };
        visitor.setDslContent(model.getDslContent());
        model.accept(visitor);
    }

    private static interface InternalParser {
        public ELNode parse(ExprLangParser var1) throws ParseException;
    }
}

