/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.parser;

import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

public class FileLineMap {
    private static final int[] EMPTY_INT = new int[0];
    private static Map<String, FileLineMap> mapsByName = new HashMap<String, FileLineMap>();
    private final CharSequence content;
    private String inputSource;
    private final int[] lineOffsets;
    private int startingLine;
    private int startingColumn;
    private int bufferPosition;
    private int tokenBeginOffset;
    private int tokenBeginColumn;
    private int tokenBeginLine;
    private int line;
    private int column;
    private BitSet parsedLines;
    private static int BUF_SIZE = 65536;

    public static FileLineMap getFileLineMapByName(String name) {
        return mapsByName.get(name);
    }

    public static void clearFileLineMapCache() {
        mapsByName.clear();
    }

    public static FileLineMap clearFileLineMapCacheEntry(String inputSource) {
        return mapsByName.remove(inputSource);
    }

    private boolean isParsedLine(int lineNumber) {
        return this.parsedLines == null || this.parsedLines.get(1 + lineNumber - this.startingLine);
    }

    public void setParsedLines(BitSet parsedLines) {
        this.parsedLines = parsedLines;
    }

    public FileLineMap(String inputSource, Reader reader, int startingLine, int startingColumn) {
        this(inputSource, FileLineMap.readToEnd(reader), startingLine, startingColumn);
    }

    public FileLineMap(String inputSource, CharSequence content) {
        this(inputSource, content, 1, 1);
    }

    public FileLineMap(String inputSource, CharSequence content, int startingLine, int startingColumn) {
        this.setInputSource(inputSource);
        this.content = FileLineMap.mungeContent(content, 0, true, false, false);
        this.lineOffsets = FileLineMap.createLineOffsetsTable(this.content);
        this.setStartPosition(startingLine, startingColumn);
    }

    public void backup(int amount) {
        for (int i = 0; i < amount; ++i) {
            if (this.column == 1) {
                this.backupLine();
                continue;
            }
            --this.column;
            --this.bufferPosition;
            if (this.bufferPosition <= 0 || this.column <= 1 || !Character.isLowSurrogate(this.content.charAt(this.bufferPosition)) || !Character.isHighSurrogate(this.content.charAt(this.bufferPosition - 1))) continue;
            --this.column;
            --this.bufferPosition;
        }
    }

    void forward(int amount) {
        for (int i = 0; i < amount; ++i) {
            if (this.column < this.getLineLength(this.line)) {
                ++this.bufferPosition;
                ++this.column;
                if (!Character.isLowSurrogate(this.content.charAt(this.bufferPosition)) || !Character.isHighSurrogate(this.content.charAt(this.bufferPosition - 1))) continue;
                ++this.bufferPosition;
                ++this.column;
                continue;
            }
            this.advanceLine();
        }
    }

    private void advanceLine() {
        do {
            ++this.line;
        } while (!this.isParsedLine(this.line) && this.line - this.startingLine < this.lineOffsets.length);
        this.bufferPosition = this.line - this.startingLine >= this.lineOffsets.length ? this.content.length() : this.getLineStartOffset(this.line);
        this.column = 1;
    }

    private void backupLine() {
        do {
            --this.line;
        } while (!this.isParsedLine(this.line) && this.line >= this.startingLine);
        if (this.line < this.startingLine) {
            this.goTo(this.startingLine, this.startingColumn);
        } else {
            this.column = this.getLineLength(this.line);
            this.bufferPosition = this.getLineStartOffset(this.line) + this.column - 1;
        }
    }

    int readChar() {
        char nextChar;
        char ch;
        if (this.bufferPosition >= this.content.length()) {
            return -1;
        }
        if (Character.isHighSurrogate(ch = this.content.charAt(this.bufferPosition++)) && this.bufferPosition < this.content.length() && Character.isLowSurrogate(nextChar = this.content.charAt(this.bufferPosition))) {
            ++this.bufferPosition;
            this.column += 2;
            return Character.toCodePoint(ch, nextChar);
        }
        if (ch == '\n') {
            this.advanceLine();
            this.column = 1;
        } else {
            ++this.column;
        }
        return ch;
    }

    String getImage() {
        CharSequence image = this.content.subSequence(this.tokenBeginOffset, this.bufferPosition);
        if (this.tokenBeginLine == this.line || this.parsedLines == null) {
            return image.toString();
        }
        boolean hasUnparsedLines = false;
        for (int i = this.tokenBeginLine; i <= this.line; ++i) {
            if (this.isParsedLine(i)) continue;
            hasUnparsedLines = true;
            break;
        }
        if (!hasUnparsedLines) {
            return image.toString();
        }
        return this.onlyRelevantPart(image, this.tokenBeginLine);
    }

    private String onlyRelevantPart(CharSequence input, int currentLine) {
        StringBuilder buf = new StringBuilder();
        boolean on = this.isParsedLine(currentLine);
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if (on) {
                buf.append(ch);
            }
            if (ch != '\n') continue;
            on = this.isParsedLine(++currentLine);
        }
        return buf.toString();
    }

    String getSuffix(int len) {
        int startPos = this.bufferPosition - len + 1;
        return this.content.subSequence(startPos, this.bufferPosition).toString();
    }

    int beginToken() {
        if (!this.isParsedLine(this.line)) {
            this.advanceLine();
        }
        this.tokenBeginOffset = this.bufferPosition;
        this.tokenBeginColumn = this.column;
        this.tokenBeginLine = this.line;
        return this.readChar();
    }

    int getBeginColumn() {
        return this.tokenBeginColumn;
    }

    int getBeginLine() {
        return this.tokenBeginLine;
    }

    int getEndColumn() {
        if (this.column == 1) {
            if (this.line == this.tokenBeginLine) {
                return 1;
            }
            return this.getLineLength(this.line - 1);
        }
        return this.column - 1;
    }

    int getEndLine() {
        if (this.column == 1 && this.line > this.tokenBeginLine) {
            return this.line - 1;
        }
        return this.line;
    }

    int getBufferPosition() {
        return this.bufferPosition;
    }

    void goTo(int line, int column) {
        this.bufferPosition = this.getOffset(line, column);
        this.line = line;
        this.column = column;
    }

    private int getLineLength(int lineNumber) {
        int startOffset = this.getLineStartOffset(lineNumber);
        int endOffset = this.getLineEndOffset(lineNumber);
        return 1 + endOffset - startOffset;
    }

    private int getLineStartOffset(int lineNumber) {
        int realLineNumber = lineNumber - this.startingLine;
        if (realLineNumber <= 0) {
            return 0;
        }
        if (realLineNumber >= this.lineOffsets.length) {
            return this.content.length();
        }
        return this.lineOffsets[realLineNumber];
    }

    private int getLineEndOffset(int lineNumber) {
        int realLineNumber = lineNumber - this.startingLine;
        if (realLineNumber < 0) {
            return 0;
        }
        if (realLineNumber >= this.lineOffsets.length) {
            return this.content.length();
        }
        if (realLineNumber == this.lineOffsets.length - 1) {
            return this.content.length() - 1;
        }
        return this.lineOffsets[realLineNumber + 1] - 1;
    }

    private void setStartPosition(int line, int column) {
        this.startingLine = line;
        this.startingColumn = column;
        this.line = line;
        this.column = column;
    }

    private int getOffset(int line, int column) {
        if (line == 0) {
            line = this.startingLine;
        }
        int columnAdjustment = line == this.startingLine ? this.startingColumn : 1;
        return this.lineOffsets[line - this.startingLine] + column - columnAdjustment;
    }

    private static String mungeContent(CharSequence content, int tabsToSpaces, boolean preserveLines, boolean javaUnicodeEscape, boolean ensureFinalEndline) {
        char lastChar;
        if (tabsToSpaces <= 0 && preserveLines && !javaUnicodeEscape) {
            char lastChar2;
            if (ensureFinalEndline && (lastChar2 = content.charAt(content.length() - 1)) != '\n' && lastChar2 != '\r') {
                if (content instanceof StringBuilder) {
                    ((StringBuilder)content).appendCodePoint(10);
                } else {
                    StringBuilder buf = new StringBuilder(content);
                    buf.appendCodePoint(10);
                    content = buf.toString();
                }
            }
            return content.toString();
        }
        StringBuilder buf = new StringBuilder();
        int index = 0;
        int col = 0;
        boolean justSawUnicodeEscape = false;
        int[] codePoints = content.codePoints().toArray();
        while (index < codePoints.length) {
            int i;
            int ch;
            if ((ch = codePoints[index++]) == 92 && javaUnicodeEscape && index < codePoints.length) {
                char last;
                if ((ch = codePoints[index++]) != 117) {
                    justSawUnicodeEscape = false;
                    buf.appendCodePoint(92);
                    buf.appendCodePoint(ch);
                    if (ch == 10) {
                        col = 0;
                        continue;
                    }
                    col += 2;
                    continue;
                }
                while (codePoints[index] == 117) {
                    ++index;
                }
                StringBuilder hexBuf = new StringBuilder(4);
                for (i = 0; i < 4; ++i) {
                    hexBuf.appendCodePoint(codePoints[index++]);
                }
                char current = (char)Integer.parseInt(hexBuf.toString(), 16);
                char c = last = buf.length() > 0 ? buf.charAt(buf.length() - 1) : (char)'\u0000';
                if (justSawUnicodeEscape && Character.isSurrogatePair(last, current)) {
                    buf.setLength(buf.length() - 1);
                    --col;
                    buf.appendCodePoint(Character.toCodePoint(last, current));
                    justSawUnicodeEscape = false;
                } else {
                    buf.append(current);
                    justSawUnicodeEscape = true;
                }
                ++col;
                continue;
            }
            if (ch == 13 && !preserveLines) {
                justSawUnicodeEscape = false;
                buf.appendCodePoint(10);
                if (index >= codePoints.length) continue;
                if ((ch = codePoints[index++]) != 10) {
                    buf.appendCodePoint(ch);
                    ++col;
                    continue;
                }
                col = 0;
                continue;
            }
            if (ch == 9 && tabsToSpaces > 0) {
                justSawUnicodeEscape = false;
                int spacesToAdd = tabsToSpaces - col % tabsToSpaces;
                for (i = 0; i < spacesToAdd; ++i) {
                    buf.appendCodePoint(32);
                    ++col;
                }
                continue;
            }
            justSawUnicodeEscape = false;
            buf.appendCodePoint(ch);
            if (ch == 10) {
                col = 0;
                continue;
            }
            ++col;
        }
        if (ensureFinalEndline && (lastChar = buf.charAt(buf.length() - 1)) != '\n' && lastChar != '\r') {
            buf.append('\n');
        }
        return buf.toString();
    }

    private static int[] createLineOffsetsTable(CharSequence content) {
        if (content.length() == 0) {
            return EMPTY_INT;
        }
        int lineCount = 0;
        int length = content.length();
        for (int i = 0; i < length; ++i) {
            char ch = content.charAt(i);
            if (ch != '\n') continue;
            ++lineCount;
        }
        if (content.charAt(length - 1) != '\n') {
            ++lineCount;
        }
        int[] lineOffsets = new int[lineCount];
        lineOffsets[0] = 0;
        int index = 1;
        for (int i = 0; i < length; ++i) {
            char ch = content.charAt(i);
            if (ch != '\n') continue;
            if (i + 1 == length) break;
            lineOffsets[index++] = i + 1;
        }
        return lineOffsets;
    }

    public String getInputSource() {
        return this.inputSource;
    }

    void setInputSource(String inputSource) {
        mapsByName.put(inputSource, this);
        this.inputSource = inputSource;
    }

    String getText(int beginLine, int beginColumn, int endLine, int endColumn) {
        int startOffset = this.getOffset(beginLine, beginColumn);
        int endOffset = this.getOffset(endLine, endColumn);
        return this.getText(startOffset, endOffset);
    }

    private String getText(int startOffset, int endOffset) {
        return this.content.subSequence(startOffset, endOffset + 1).toString();
    }

    static String readToEnd(Reader reader) {
        try {
            return FileLineMap.readFully(reader);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    static String readFully(Reader reader) throws IOException {
        char[] block = new char[BUF_SIZE];
        int charsRead = reader.read(block);
        if (charsRead < 0) {
            throw new IOException("No input");
        }
        if (charsRead < BUF_SIZE) {
            char[] result = new char[charsRead];
            System.arraycopy(block, 0, result, 0, charsRead);
            reader.close();
            return new String(block, 0, charsRead);
        }
        StringBuilder buf = new StringBuilder();
        buf.append(block);
        do {
            if ((charsRead = reader.read(block)) <= 0) continue;
            buf.append(block, 0, charsRead);
        } while (charsRead == BUF_SIZE);
        reader.close();
        return buf.toString();
    }

    public static String stringFromBytes(byte[] bytes) {
        int fourthByte;
        int arrayLength = bytes.length;
        int firstByte = arrayLength > 0 ? Byte.toUnsignedInt(bytes[0]) : 1;
        int secondByte = arrayLength > 1 ? Byte.toUnsignedInt(bytes[1]) : 1;
        int thirdByte = arrayLength > 2 ? Byte.toUnsignedInt(bytes[2]) : 1;
        int n = fourthByte = arrayLength > 3 ? Byte.toUnsignedInt(bytes[3]) : 1;
        if (firstByte == 239 && secondByte == 187 && thirdByte == 191) {
            return new String(bytes, 3, bytes.length - 3, Charset.forName("UTF-8"));
        }
        if (firstByte == 0 && secondByte == 0 && thirdByte == 254 && fourthByte == 255) {
            return new String(bytes, 4, bytes.length - 4, Charset.forName("UTF-32BE"));
        }
        if (firstByte == 255 && secondByte == 254 && thirdByte == 0 && fourthByte == 0) {
            return new String(bytes, 4, bytes.length - 4, Charset.forName("UTF-32LE"));
        }
        if (firstByte == 254 && secondByte == 255) {
            return new String(bytes, 2, bytes.length - 2, Charset.forName("UTF-16BE"));
        }
        if (firstByte == 255 && secondByte == 254) {
            return new String(bytes, 2, bytes.length - 2, Charset.forName("UTF-16LE"));
        }
        return new String(bytes, Charset.forName("UTF-8"));
    }
}

