/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.parser;

import org.talend.maplang.el.parser.ExprLangConstants;
import org.talend.maplang.el.parser.ExprLangLexer;
import org.talend.maplang.el.parser.ExprLangParser;
import org.talend.maplang.el.parser.FileLineMap;
import org.talend.maplang.el.parser.Location;

public class Token
implements ExprLangConstants {
    private ExprLangConstants.TokenType type;
    private String inputSource;
    private int beginLine;
    private int beginColumn;
    private int endLine;
    private int endColumn;
    private String image;
    private Token next;
    private Token previousToken;
    private Token nextToken;
    private boolean unparsed;

    public boolean hasValidLocation() {
        return this.beginLine >= 0 && this.beginColumn >= 0;
    }

    public Location getLocation() {
        return new Location(this.beginLine, this.beginColumn);
    }

    public String getInputSource() {
        return this.inputSource;
    }

    public void setInputSource(String inputSource) {
        this.inputSource = inputSource;
    }

    public ExprLangConstants.TokenType getType() {
        return this.type;
    }

    void setType(ExprLangConstants.TokenType type) {
        this.type = type;
    }

    public boolean isVirtual() {
        return this.type == ExprLangConstants.TokenType.EOF;
    }

    public boolean isSkipped() {
        return false;
    }

    public void setBeginColumn(int beginColumn) {
        this.beginColumn = beginColumn;
    }

    public void setEndColumn(int endColumn) {
        this.endColumn = endColumn;
    }

    public void setBeginLine(int beginLine) {
        this.beginLine = beginLine;
    }

    public void setEndLine(int endLine) {
        this.endLine = endLine;
    }

    public int getBeginLine() {
        return this.beginLine;
    }

    public int getBeginColumn() {
        return this.beginColumn;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public final Token getNext() {
        return this.getNextParsedToken();
    }

    final void setNext(Token next) {
        this.setNextParsedToken(next);
    }

    public Token getNextParsedToken() {
        return this.next;
    }

    void setNextParsedToken(Token next) {
        this.next = next;
    }

    public Token getNextToken() {
        return this.nextToken;
    }

    void setNextToken(Token nextToken) {
        this.nextToken = nextToken;
    }

    public Token getPreviousToken() {
        return this.previousToken;
    }

    void setPreviousToken(Token previousToken) {
        this.previousToken = previousToken;
    }

    public FileLineMap getFileLineMap() {
        return FileLineMap.getFileLineMapByName(this.getInputSource());
    }

    public String getSource() {
        if (this.type == ExprLangConstants.TokenType.EOF) {
            return "";
        }
        return this.getFileLineMap().getText(this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn());
    }

    Token() {
    }

    public Token(int kind) {
        this(kind, null);
        this.type = ExprLangConstants.TokenType.values()[kind];
    }

    public Token(int kind, String image) {
        this.type = ExprLangConstants.TokenType.values()[kind];
        this.image = image;
    }

    public Token(ExprLangConstants.TokenType type, String image, String inputSource) {
        this.type = type;
        this.image = image;
        this.inputSource = inputSource;
    }

    public boolean isUnparsed() {
        return this.unparsed;
    }

    public void setUnparsed(boolean unparsed) {
        this.unparsed = unparsed;
    }

    static Token merge(Token t1, Token t2, ExprLangConstants.TokenType type) {
        Token merged = Token.newToken(type, t1.getImage() + t2.getImage(), t1.getInputSource());
        t1.copyLocationInfo(merged);
        merged.setEndColumn(t2.getEndColumn());
        merged.setEndLine(t2.getEndLine());
        merged.setNext(t2.getNext());
        merged.setNextToken(t2.getNextToken());
        return merged;
    }

    static Token split(Token tok, int length, ExprLangConstants.TokenType type1, ExprLangConstants.TokenType type2) {
        String img1 = tok.getImage().substring(0, length);
        String img2 = tok.getImage().substring(length);
        Token t1 = Token.newToken(type1, img1, tok.getInputSource());
        Token t2 = Token.newToken(type2, img2, tok.getInputSource());
        t1.setBeginColumn(tok.getBeginColumn());
        t1.setEndColumn(tok.getBeginColumn() + length - 1);
        t1.setBeginLine(tok.getBeginLine());
        t1.setEndLine(tok.getBeginLine());
        t1.setPreviousToken(tok.getPreviousToken());
        t2.setBeginColumn(t1.getEndColumn() + 1);
        t2.setEndColumn(tok.getEndColumn());
        t2.setBeginLine(tok.getBeginLine());
        t2.setEndLine(tok.getEndLine());
        t1.setNext(t2);
        t1.setNextToken(t2);
        t2.setPreviousToken(t1);
        t2.setNext(tok.getNext());
        t2.setNextToken(tok.getNextToken());
        return t1;
    }

    public void clearChildren() {
    }

    public String getNormalizedText() {
        if (this.getType() == ExprLangConstants.TokenType.EOF) {
            return "EOF";
        }
        return this.getImage();
    }

    public String toString() {
        return this.getNormalizedText();
    }

    public void copyLocationInfo(Token from) {
        if (this.getInputSource() == null && from.getInputSource() != null) {
            this.setInputSource(from.getInputSource());
        }
        this.setBeginLine(from.getBeginLine());
        this.setBeginColumn(from.getBeginColumn());
        this.setEndLine(from.getEndLine());
        this.setEndColumn(from.getEndColumn());
        this.next = from.next;
        this.nextToken = from.nextToken;
        this.previousToken = from.previousToken;
    }

    public void copyLocationInfo(Token start, Token end) {
        if (this.getInputSource() == null && start.getInputSource() != null) {
            this.setInputSource(start.getInputSource());
        }
        if (this.getInputSource() == null && start.getInputSource() != null) {
            this.setInputSource(start.getInputSource());
        }
        this.setBeginLine(start.getBeginLine());
        this.setBeginColumn(start.getBeginColumn());
        this.setEndLine(end.getEndLine());
        this.setEndColumn(end.getEndColumn());
        this.previousToken = start.previousToken;
        this.next = end.next;
        this.nextToken = end.nextToken;
    }

    public static Token newToken(ExprLangConstants.TokenType type, String image, String inputSource) {
        return new Token(type, image, inputSource);
    }

    public static Token newToken(ExprLangConstants.TokenType type, String image, ExprLangLexer lexer) {
        return Token.newToken(type, image, lexer.getInputSource());
    }

    public static Token newToken(ExprLangConstants.TokenType type, String image, ExprLangParser parser) {
        return Token.newToken(type, image, parser.getInputSource());
    }
}

