/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.parser.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import org.talend.maplang.el.parser.DslContent;
import org.talend.maplang.el.parser.ExprLangException;
import org.talend.maplang.el.parser.Location;
import org.talend.maplang.el.parser.Messages;
import org.talend.maplang.el.parser.model.ELNodePrinter;
import org.talend.maplang.el.parser.model.ELNodeType;
import org.talend.maplang.el.parser.model.ExprModelVisitor;

public class ELNode {
    private ELNodeType type;
    private String image;
    private ELNode parent;
    private List<ELNode> children = new ArrayList<ELNode>();
    private Location beginLocation;
    private Location endLocation;
    private DslContent dslContent;

    public ELNode() {
        this(ELNodeType.NONE);
    }

    public ELNode(DslContent content) {
        this(ELNodeType.ROOT);
        this.dslContent = content;
    }

    public ELNode(ELNodeType type) {
        this(type, null);
    }

    public ELNode(ELNodeType type, String image) {
        this.type = type;
        this.image = image != null ? image : this.initImage(type);
    }

    private String initImage(ELNodeType type) {
        switch (type) {
            case AND: {
                return "&&";
            }
            case ARRAY: {
                return "[..]";
            }
            case OR: {
                return "||";
            }
            case ASSIGN: {
                return "=";
            }
            case BOOLEAN_LITERAL: {
                return "false";
            }
            case BYTES_LITERAL: {
                return "0x0000";
            }
            case DECIMAL_LITERAL: {
                return "0.0";
            }
            case DIVIDE: {
                return "/";
            }
            case DOUBLE_LITERAL: {
                return "0.0d";
            }
            case CASE: {
                return "case";
            }
            case CONDITION: {
                return "if";
            }
            case DEFAULT: {
                return "default";
            }
            case ELSE: {
                return "else";
            }
            case EQUAL: {
                return "==";
            }
            case FLOAT_LITERAL: {
                return "0.0f";
            }
            case GREATER_OR_EQUAL: {
                return ">=";
            }
            case GREATER_THAN: {
                return ">";
            }
            case IF_THEN_ELSE: {
                return "ifThenElse";
            }
            case INTEGER_LITERAL: {
                return "0";
            }
            case LONG_LITERAL: {
                return "0L";
            }
            case LOWER_OR_EQUAL: {
                return "<=";
            }
            case LOWER_THAN: {
                return "<";
            }
            case MINUS: {
                return "-";
            }
            case MODULO: {
                return "%";
            }
            case MULTIPLY: {
                return "*";
            }
            case NOT: {
                return "!";
            }
            case NOT_EQUAL: {
                return "!=";
            }
            case NULL_LITERAL: {
                return "null";
            }
            case PLUS: {
                return "+";
            }
            case STRING_LITERAL: {
                return "''";
            }
            case SWITCH: {
                return "switch";
            }
            case THEN: {
                return "then";
            }
        }
        return null;
    }

    public DslContent getDslContent() {
        return this.dslContent;
    }

    public void setBeginLocation(int line, int column) {
        this.beginLocation = new Location(line, column);
    }

    public boolean hasBeginLocation() {
        return this.beginLocation != null;
    }

    public Location getBeginLocation() {
        return this.beginLocation;
    }

    public void setLocation(int line, int column) {
        this.beginLocation = new Location(line, column);
    }

    public boolean hasLocation() {
        return this.beginLocation != null;
    }

    public Location getLocation() {
        return this.beginLocation;
    }

    public void setEndLocation(int line, int column) {
        this.endLocation = new Location(line, column);
    }

    public boolean hasEndLocation() {
        return this.endLocation != null;
    }

    public Location getEndLocation() {
        return this.endLocation;
    }

    public boolean hasValidLocation() {
        return this.beginLocation != null && this.beginLocation.isValid();
    }

    public Location getFirstValidLocation() {
        if (this.hasValidLocation()) {
            return this.beginLocation;
        }
        for (ELNode child : this.children) {
            Location firstValidLocation = child.getFirstValidLocation();
            if (firstValidLocation == null) continue;
            return firstValidLocation;
        }
        return null;
    }

    public int getLine() {
        return this.beginLocation == null ? -1 : this.beginLocation.getLine();
    }

    public int getColumn() {
        return this.beginLocation == null ? -1 : this.beginLocation.getColumn();
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public ELNode getRoot() {
        ELNode node = this;
        while (!node.isRoot()) {
            node = node.getParent();
        }
        return node;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public ELNode getParent() {
        return this.parent;
    }

    public ELNodeType getType() {
        return this.type;
    }

    public String getImage() {
        return this.image;
    }

    @Deprecated
    public String getRawText() {
        return this.image;
    }

    @Deprecated
    public String getLabel() {
        return this.image;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public boolean hasSingleChild() {
        return this.children.size() == 1;
    }

    public int getNbrOfChildren() {
        return this.children.size();
    }

    public int getChildIndex(ELNode child) {
        return this.children.indexOf(child);
    }

    public ELNode getChild(int index) {
        return this.children.get(index);
    }

    public List<ELNode> getChildren() {
        return this.children;
    }

    public void addChild(ELNode child) {
        this.children.add(child);
        child.setParent(this);
    }

    public void removeChild(ELNode child) {
        this.children.remove(child);
        child.setParent(null);
    }

    public void addChild(ELNode child, int index) {
        this.children.add(index, child);
        child.setParent(this);
    }

    public void addChild(ELNodeType type, String image) {
        this.addChild(new ELNode(type, image));
    }

    public void addChildren(List<ELNode> children) {
        for (ELNode child : children) {
            this.addChild(child);
        }
    }

    public ELNode addFunctionCall(String functionName, ELNode argsNode) {
        ELNode funcNode = new ELNode(ELNodeType.FUNCTION_CALL, functionName);
        for (ELNode arg : argsNode.getChildren()) {
            funcNode.addChild(arg);
        }
        this.addChild(funcNode);
        return funcNode;
    }

    public void addMultiOperandNode(ELNode node) {
        ELNode opNode = null;
        ArrayList<ELNode> operands = new ArrayList<ELNode>();
        for (int i = 0; i < node.children.size(); ++i) {
            ELNode child = node.children.get(i);
            if (child.isOp() && !child.hasChildren()) {
                if (opNode == null) {
                    opNode = child;
                    continue;
                }
                if (opNode.getType() == child.getType()) continue;
                throw new ExprLangException(Messages.getMessage("ELNode.multiOperandError", new Object[0]));
            }
            operands.add(child);
        }
        for (ELNode operand : operands) {
            opNode.addChild(operand);
        }
        this.addChild(opNode);
    }

    public void addBinaryOperandNode(ELNode node) {
        ELNode currentNode = this;
        Stack<ELNode> stack = new Stack<ELNode>();
        for (int i = node.children.size() - 1; i >= 0; --i) {
            ELNode child = node.children.get(i);
            if (child.isOp() && !child.hasChildren()) {
                currentNode.addChild(child);
                currentNode = child;
                continue;
            }
            stack.push(child);
        }
        while (!stack.isEmpty()) {
            ELNode n = (ELNode)stack.pop();
            if (currentNode.children.size() >= 2) {
                currentNode = currentNode.getParent();
            }
            currentNode.addChild(n);
        }
    }

    public void addBuildNode(ELNode buildNode) {
        this.checkBuildNode(buildNode);
        this.addChild(buildNode.children.get(0));
    }

    public List<ELNode> getChildren(ELNodeType childType) {
        return this.children.stream().filter(child -> child.getType() == childType).collect(Collectors.toList());
    }

    public ELNode getFirstChild(ELNodeType ... childTypes) {
        return this.children.stream().filter(x -> ELNodeType.isOneOfType(x.getType(), childTypes)).findFirst().orElse(null);
    }

    public boolean hasChildOfType(ELNodeType type) {
        return this.children.stream().anyMatch(x -> x.getType() == type);
    }

    public boolean hasNoType() {
        return this.type == ELNodeType.NONE;
    }

    public boolean isOp() {
        return this.isLogicalOp() || this.isCompOp() || this.isAddOp() || this.isMultOp();
    }

    public boolean isLogicalOp() {
        return this.type == ELNodeType.AND || this.type == ELNodeType.OR;
    }

    public boolean isCompOp() {
        return this.type == ELNodeType.EQUAL || this.type == ELNodeType.NOT_EQUAL || this.type == ELNodeType.GREATER_OR_EQUAL || this.type == ELNodeType.GREATER_THAN || this.type == ELNodeType.LOWER_OR_EQUAL || this.type == ELNodeType.LOWER_THAN;
    }

    public boolean isAddOp() {
        return this.type == ELNodeType.PLUS || this.type == ELNodeType.MINUS;
    }

    public boolean isMultOp() {
        return this.type == ELNodeType.MULTIPLY || this.type == ELNodeType.DIVIDE || this.type == ELNodeType.MODULO;
    }

    public boolean isCompatibleOp(ELNode node) {
        return this.isLogicalOp() && node.isLogicalOp() || this.isCompOp() && node.isCompOp() || this.isAddOp() && node.isAddOp() || this.isMultOp() && node.isMultOp();
    }

    protected void checkBuildNode(ELNode node) {
        assert (node.hasNoType());
        assert (node.children.size() == 1);
    }

    protected void setParent(ELNode parent) {
        this.parent = parent;
    }

    public boolean isFunction() {
        return this.type == ELNodeType.FUNCTION_CALL;
    }

    public <T> T accept(ExprModelVisitor<T> visitor) {
        switch (this.type) {
            case ROOT: {
                return visitor.visitRoot(this);
            }
            case EXPR_BLOCK: {
                return visitor.visitBlock(this);
            }
            case BOOLEAN_LITERAL: 
            case BYTES_LITERAL: 
            case DECIMAL_LITERAL: 
            case DOUBLE_LITERAL: 
            case FLOAT_LITERAL: 
            case INTEGER_LITERAL: 
            case LONG_LITERAL: 
            case NULL_LITERAL: 
            case STRING_LITERAL: {
                return visitor.visitLiteral(this);
            }
            case ARRAY: {
                return visitor.visitArray(this);
            }
            case EQUAL: 
            case GREATER_OR_EQUAL: 
            case GREATER_THAN: 
            case LOWER_OR_EQUAL: 
            case LOWER_THAN: 
            case NOT_EQUAL: {
                return visitor.visitCompOp(this);
            }
            case MINUS: 
            case PLUS: {
                return visitor.visitAddOp(this);
            }
            case DIVIDE: 
            case MODULO: 
            case MULTIPLY: {
                return visitor.visitMultOp(this);
            }
            case AND: 
            case OR: {
                return visitor.visitLogicalOp(this);
            }
            case NOT: {
                return visitor.visitNot(this);
            }
            case HPATH: {
                return visitor.visitHPath(this);
            }
            case VARIABLE: {
                return visitor.visitVariable(this);
            }
            case FUNCTION_CALL: {
                return visitor.visitFunctionCall(this);
            }
            case ASSIGN: {
                return visitor.visitAssignment(this);
            }
            case IF_THEN_ELSE: {
                return visitor.visitIfThenElse(this);
            }
            case SWITCH: {
                return visitor.visitSwitchCases(this);
            }
            case CASE: 
            case CONDITION: 
            case DEFAULT: 
            case ELSE: 
            case THEN: {
                return this.children.get(0).accept(visitor);
            }
        }
        throw new ExprLangException(Messages.getMessage("ELNode.visitorError", new Object[]{this.type}));
    }

    public ELNode copy() {
        ELNode copiedNode = new ELNode(this.getType(), this.getImage());
        if (this.hasBeginLocation()) {
            copiedNode.setBeginLocation(this.getLine(), this.getColumn());
        }
        for (ELNode child : this.children) {
            ELNode copiedChild = child.copy();
            copiedNode.addChild(copiedChild);
        }
        return copiedNode;
    }

    public String toString() {
        return ELNodePrinter.print(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.children == null ? 0 : this.children.hashCode());
        result = 31 * result + (this.image == null ? 0 : this.image.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ELNode other = (ELNode)obj;
        if (this.type == null ? other.type != null : !this.type.equals((Object)other.type)) {
            return false;
        }
        if (this.type != null && this.type != ELNodeType.ROOT && (this.image == null ? other.image != null : !this.image.equals(other.image))) {
            return false;
        }
        return !(this.children == null ? other.children != null : !this.children.equals(other.children));
    }
}

