/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.el.parser.model;

import org.talend.maplang.el.parser.model.ELNode;
import org.talend.maplang.el.parser.model.ELNodeType;

public class ELNodePrinter {
    private static final String DEFAULT_TAB = "\t";

    public static String printAsTree(ELNode node) {
        StringBuilder buf = new StringBuilder();
        ELNodePrinter.exportAsReadableString(buf, node);
        return buf.toString();
    }

    public static String printAsTree(ELNode node, String tab) {
        StringBuilder buf = new StringBuilder();
        ELNodePrinter.exportAsReadableString(buf, node, tab);
        return buf.toString();
    }

    public static String printAsTree(ELNode node, String tab, boolean withLocation) {
        StringBuilder buf = new StringBuilder();
        ELNodePrinter.exportAsReadableString(buf, node, tab, withLocation);
        return buf.toString();
    }

    protected static void exportAsReadableString(StringBuilder buf, ELNode node) {
        ELNodePrinter.exportAsReadableString(buf, node, DEFAULT_TAB);
    }

    protected static void exportAsReadableString(StringBuilder buf, ELNode node, boolean withLocation) {
        ELNodePrinter.exportAsReadableString(buf, node, DEFAULT_TAB, withLocation);
    }

    protected static void exportAsReadableString(StringBuilder buf, ELNode node, String tab) {
        ELNodePrinter.exportAsReadableString(buf, node, 0, tab, false);
    }

    protected static void exportAsReadableString(StringBuilder buf, ELNode node, String tab, boolean withLocation) {
        ELNodePrinter.exportAsReadableString(buf, node, 0, tab, withLocation);
    }

    protected static void exportAsReadableString(StringBuilder buf, ELNode node, int level, String tab, boolean withLocation) {
        for (int i = 0; i < level; ++i) {
            buf.append(tab);
        }
        ELNodePrinter.exportTypeAndImage(buf, node, withLocation);
        buf.append("\n");
        node.getChildren().stream().forEach(child -> ELNodePrinter.exportAsReadableString(buf, child, level + 1, tab, withLocation));
    }

    protected static void exportTypeAndImage(StringBuilder buf, ELNode node, boolean withLocation) {
        ELNodeType type = node.getType();
        String image = node.getImage();
        buf.append((Object)type);
        buf.append(" [");
        if (type == ELNodeType.ROOT) {
            buf.append("null");
        } else {
            buf.append(image);
        }
        buf.append("]");
        if (withLocation) {
            buf.append(" (");
            buf.append(node.getLine());
            buf.append(", ");
            buf.append(node.getColumn());
            buf.append(")");
        }
    }

    public static String print(ELNode node) {
        StringBuilder buf = new StringBuilder();
        ELNodePrinter.appendString(buf, node);
        return buf.toString();
    }

    protected static boolean appendImage(StringBuilder buf, ELNode node) {
        String image = node.getImage();
        ELNodeType type = node.getType();
        if (image != null && type != ELNodeType.ROOT) {
            buf.append(image);
            return true;
        }
        return false;
    }

    protected static void appendString(StringBuilder buf, ELNode node) {
        boolean appended = ELNodePrinter.appendImage(buf, node);
        if (node.hasChildren()) {
            int size = node.getNbrOfChildren();
            if (appended || size > 1) {
                buf.append("(");
            }
            for (int i = 0; i < size; ++i) {
                ELNodePrinter.appendString(buf, node.getChild(i));
                if (i >= size - 1) continue;
                buf.append(",");
            }
            if (appended || size > 1) {
                buf.append(")");
            }
        } else if (node.isFunction()) {
            buf.append("()");
        }
    }

    public static String prettyPrint(ELNode node) {
        StringBuilder buf = new StringBuilder();
        ELNodePrinter.prettyPrint(buf, node);
        return buf.toString();
    }

    protected static void prettyPrint(StringBuilder buf, ELNode node) {
        int size = node.getNbrOfChildren();
        ELNodeType type = node.getType();
        String image = node.getImage();
        switch (type) {
            case ROOT: {
                ELNodePrinter.prettyPrintChild(buf, node, false);
                break;
            }
            case EXPR_BLOCK: {
                if (size > 1) {
                    buf.append("{");
                }
                ELNodePrinter.prettyPrintChildren(buf, node, "; ", false);
                if (size <= 1) break;
                buf.append("}");
                break;
            }
            case AND: 
            case OR: 
            case PLUS: 
            case MINUS: 
            case MULTIPLY: 
            case DIVIDE: 
            case MODULO: 
            case EQUAL: 
            case NOT_EQUAL: 
            case GREATER_OR_EQUAL: 
            case GREATER_THAN: 
            case LOWER_OR_EQUAL: 
            case LOWER_THAN: {
                ELNodePrinter.prettyPrintChildren(buf, node, " " + image + " ", ELNodePrinter.needParentheses(node));
                break;
            }
            case FUNCTION_CALL: 
            case NOT: {
                buf.append(image);
                ELNodePrinter.prettyPrintChildren(buf, node, ", ", true);
                break;
            }
            case ASSIGN: {
                ELNodePrinter.prettyPrintChildren(buf, node, " " + image + " ", false);
                break;
            }
            case IF_THEN_ELSE: {
                int index = 0;
                buf.append("IF ");
                ELNodePrinter.prettyPrint(buf, node.getChild(index++));
                while (index < size) {
                    ELNode child = node.getChild(index);
                    if (child.getType() == ELNodeType.CONDITION) {
                        buf.append(" ELSEIF ");
                        ELNodePrinter.prettyPrint(buf, child);
                    } else if (child.getType() == ELNodeType.THEN) {
                        buf.append(" ");
                        ELNodePrinter.prettyPrint(buf, child);
                    } else if (child.getType() == ELNodeType.ELSE) {
                        buf.append(" ELSE ");
                        ELNodePrinter.prettyPrint(buf, child);
                    }
                    ++index;
                }
                break;
            }
            case CONDITION: {
                ELNodePrinter.prettyPrintChild(buf, node, true);
                break;
            }
            case THEN: 
            case ELSE: {
                ELNodePrinter.prettyPrintChild(buf, node, false);
                break;
            }
            case SWITCH: {
                int index = 0;
                buf.append("SWITCH ");
                ELNodePrinter.prettyPrint(buf, node.getChild(index++));
                buf.append(" {");
                while (index < size) {
                    ELNodePrinter.prettyPrint(buf, node.getChild(index));
                    ++index;
                }
                buf.append(" } ");
                break;
            }
            case CASE: {
                buf.append(" CASE ");
                ELNodePrinter.prettyPrint(buf, node.getChild(0));
                buf.append(" : ");
                ELNodePrinter.prettyPrint(buf, node.getChild(1));
                break;
            }
            case DEFAULT: {
                buf.append(" DEFAULT : ");
                ELNodePrinter.prettyPrintChild(buf, node, false);
                break;
            }
            default: {
                buf.append(image);
            }
        }
    }

    protected static void prettyPrintChild(StringBuilder buf, ELNode node, boolean withParentheses) {
        if (withParentheses) {
            buf.append("(");
        }
        ELNodePrinter.prettyPrint(buf, node.getChild(0));
        if (withParentheses) {
            buf.append(")");
        }
    }

    protected static void prettyPrintChildren(StringBuilder buf, ELNode node, String separator, boolean withParentheses) {
        int size = node.getNbrOfChildren();
        if (withParentheses) {
            buf.append("(");
        }
        for (int i = 0; i < size; ++i) {
            ELNodePrinter.prettyPrint(buf, node.getChild(i));
            if (i >= size - 1) continue;
            buf.append(separator);
        }
        if (withParentheses) {
            buf.append(")");
        }
    }

    protected static boolean needParentheses(ELNode node) {
        ELNode parent = node.getParent();
        return parent != null && parent.getType() != ELNodeType.ROOT && parent.getType() != ELNodeType.EXPR_BLOCK && parent.getType() != ELNodeType.THEN && parent.getType() != ELNodeType.ELSE && parent.getType() != ELNodeType.CASE && parent.getType() != ELNodeType.DEFAULT;
    }
}

