/*
 * Decompiled with CFR 0.152.
 */
package org.talend.maplang.hpath.mapstore;

import java.util.SortedMap;
import java.util.TreeMap;
import org.talend.maplang.hpath.HPathStore;
import org.talend.maplang.hpath.HPathStoreException;

public class BaseHPathStore
implements HPathStore {
    private TreeMap<String, Object> _store = new TreeMap();
    private boolean _markPending;
    private TreeMap<String, Object> _backupStore;

    private void checkMark() {
        if (this._markPending) {
            this._backupStore = new TreeMap<String, Object>((SortedMap<String, Object>)this._store);
            this._markPending = false;
        }
    }

    @Override
    public Object put(String path, Object value) {
        this.checkMark();
        return this._store.put(path, value);
    }

    @Override
    public boolean contains(String path) {
        return this._store.containsKey(path);
    }

    @Override
    public Object get(String path) throws HPathStoreException {
        return this._store.get(path);
    }

    @Override
    public Object remove(String path) {
        this.checkMark();
        return this._store.remove(path);
    }

    @Override
    public void clear() {
        this._store.clear();
        this._markPending = false;
        this._backupStore = null;
    }

    @Override
    public void mark() {
        this._markPending = true;
    }

    @Override
    public void reset() {
        if (this._backupStore != null) {
            this._store.clear();
            this._store.putAll(this._backupStore);
            this._backupStore = null;
        }
        this._markPending = false;
    }

    public String toString() {
        return this.toString(",");
    }

    public String toString(String separator) {
        return this.toString(separator, null);
    }

    public String toString(String separator, StringConverter converter) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        this._store.forEach((k, v) -> {
            if (sb.length() > 1) {
                sb.append(separator);
            }
            sb.append((String)k);
            sb.append("=");
            sb.append(converter != null ? converter.toString(v) : (v == null ? "null" : v.toString()));
        });
        sb.append("]");
        return sb.toString();
    }

    public static interface StringConverter {
        public String toString(Object var1);
    }
}

