/*
 * Decompiled with CFR 0.152.
 */
package org.talend.trr.runtime;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.talend.dataquality.semantic.snapshot.DictionarySnapshot;
import org.talend.maplang.el.interpreter.api.ExprInterpreter;
import org.talend.maplang.el.interpreter.api.ExprInterpreterFactory;
import org.talend.maplang.el.interpreter.api.ExprLangContext;
import org.talend.maplang.el.parser.ExprLangException;
import org.talend.trr.runtime.Rule;
import org.talend.trr.runtime.RuleExecutionResult;
import org.talend.trr.runtime.exception.RuleExecutionException;
import org.talend.trr.runtime.function.OverriddenFunctionClassLoader;
import org.talend.trr.runtime.model.DataType;
import org.talend.trr.runtime.model.Parameter;
import org.talend.trr.runtime.model.Variable;
import org.talend.trr.runtime.service.RuleChecker;
import org.talend.trr.runtime.service.RuleProvider;
import org.talend.trr.runtime.util.VariableUtils;
import org.talend.tsd.maven.connector.maven.exception.MavenResolutionException;

public abstract class RuleExecution<T extends RuleExecutionResult> {
    protected Rule rule;
    protected final DictionarySnapshot dictionarySnapshot;
    protected ExprInterpreter interpreter;
    protected Map<String, Variable> variables;
    protected List<Parameter> parameters;
    protected List<String> columnNames;
    protected Map<String, DataType> types;
    @Deprecated
    private String tenantId;

    public RuleExecution(RuleProvider ruleProvider, UUID ruleId, Long ruleVersion, DictionarySnapshot dictionarySnapshot) throws RuleExecutionException {
        this("", ruleProvider, ruleId, ruleVersion, dictionarySnapshot);
    }

    public RuleExecution(Rule rule, DictionarySnapshot dictionarySnapshot) throws RuleExecutionException {
        this("", rule, dictionarySnapshot);
    }

    @Deprecated
    public RuleExecution(String tenantId, RuleProvider ruleProvider, UUID ruleId, Long ruleVersion, DictionarySnapshot dictionarySnapshot) throws RuleExecutionException {
        this.rule = this.loadRule(ruleProvider, ruleId, ruleVersion);
        this.dictionarySnapshot = dictionarySnapshot;
        this.initRule(tenantId, this.rule);
    }

    @Deprecated
    public RuleExecution(String tenantId, Rule rule, DictionarySnapshot dictionarySnapshot) throws RuleExecutionException {
        this.dictionarySnapshot = dictionarySnapshot;
        this.initRule(tenantId, rule);
    }

    private void initRule(String tenantId, Rule rule) throws RuleExecutionException {
        this.tenantId = tenantId;
        this.rule = rule;
        RuleChecker.checkIfViable(rule, this.dictionarySnapshot);
        String expression = rule.getAdvancedExpression();
        try {
            this.variables = VariableUtils.extractVariables(expression);
        }
        catch (ExprLangException e) {
            throw new RuleExecutionException("Parsing error for the expression: " + expression, e);
        }
        ExprLangContext context = new ExprLangContext();
        context.setExtensionsClassLoader(new OverriddenFunctionClassLoader());
        this.interpreter = ExprInterpreterFactory.create(context);
    }

    public Rule getRule() {
        return this.rule;
    }

    public Map<String, Variable> getVariables() {
        return this.variables;
    }

    public List<Parameter> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public abstract boolean execute(Object ... var1);

    public abstract T getResults();

    public void init(List<String> columnNames, List<Parameter> parameters, Map<String, DataType> types) throws RuleExecutionException {
        this.columnNames = columnNames;
        this.parameters = parameters;
        this.types = types;
    }

    public int getColumnIndex(String columnName) {
        return this.columnNames.indexOf(columnName);
    }

    @Deprecated
    public Optional<Parameter> getVarName(String columnName) {
        return this.findColumnParameterByValue(columnName);
    }

    public Optional<Parameter> findColumnParameterByValue(String value) {
        return this.parameters.stream().filter(param -> param.isColumn() && param.getValue().equals(value)).findFirst();
    }

    public Optional<Parameter> findColumnParameterByName(String name) {
        return this.parameters.stream().filter(param -> param.isColumn() && param.getName().equals(name)).findFirst();
    }

    private Rule loadRule(RuleProvider ruleProvider, UUID ruleId, Long version) throws RuleExecutionException {
        Optional<Rule> maybeFoundRule;
        try {
            maybeFoundRule = ruleProvider.getRule(ruleId, version);
        }
        catch (MavenResolutionException mavenResolutionException) {
            throw new RuleExecutionException("Impossible to retrieve rule with the current version", mavenResolutionException);
        }
        return maybeFoundRule.orElseThrow(() -> new RuleExecutionException("Rule not found"));
    }

    @Deprecated
    public String getTenantId() {
        return this.tenantId;
    }
}

