/*
 * Decompiled with CFR 0.152.
 */
package org.talend.trr.runtime.converter;

import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.talend.dataquality.statistics.type.TypeInferenceUtils;
import org.talend.trr.runtime.converter.Converter;
import org.talend.trr.runtime.converter.UnableToConvertException;
import org.talend.trr.runtime.converter.ValueType;
import org.talend.trr.runtime.converter.date.DateToLocalDateConverter;
import org.talend.trr.runtime.converter.date.NumberToDateTimeConverter;
import org.talend.trr.runtime.converter.date.StringToDateTimeConverter;
import org.talend.trr.runtime.model.DataType;

public final class ConverterProvider {
    private static final Map<ValueType, ConverterProvider> converterProviders = new EnumMap<ValueType, ConverterProvider>(ValueType.class);
    private final Map<Class<?>, Converter> converters = new HashMap();

    private ConverterProvider() {
    }

    public static ConverterProvider get(DataType dataType) {
        if (EnumUtils.isValidEnumIgnoreCase(ValueType.class, dataType.getType())) {
            ValueType valueType = EnumUtils.getEnumIgnoreCase(ValueType.class, dataType.getType());
            switch (valueType) {
                case DATE: {
                    return new ConverterProvider().put(Date.class, new DateToLocalDateConverter()).put(String.class, new StringToDateTimeConverter.StringToDate().withFormats(dataType.getPatterns())).put(Number.class, new NumberToDateTimeConverter.NumberToDate().withFormats(dataType.getFormats()));
                }
                case TIME: {
                    return new ConverterProvider().put(String.class, new StringToDateTimeConverter.StringToTime().withFormats(dataType.getPatterns())).put(Number.class, new NumberToDateTimeConverter.NumberToTime().withFormats(dataType.getFormats()));
                }
                case DATETIME: {
                    return new ConverterProvider().put(String.class, new StringToDateTimeConverter.StringToDateTime().withFormats(dataType.getPatterns()));
                }
            }
            return converterProviders.get((Object)valueType);
        }
        return null;
    }

    private static Number createNumber(String value) throws UnableToConvertException {
        if (StringUtils.isNotEmpty(value)) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                throw new UnableToConvertException(e);
            }
        }
        throw new UnableToConvertException("empty value");
    }

    private static double doubleValue(String value) throws UnableToConvertException {
        if (TypeInferenceUtils.isDouble((String)value)) {
            return ConverterProvider.createNumber(value).doubleValue();
        }
        throw new UnableToConvertException(String.format("%s is not a double value", value));
    }

    private static float floatValue(String value) throws UnableToConvertException {
        if (TypeInferenceUtils.isDouble((String)value)) {
            return ConverterProvider.createNumber(value).floatValue();
        }
        throw new UnableToConvertException(String.format("%s is not a float value", value));
    }

    private static long longValue(String value) throws UnableToConvertException {
        if (TypeInferenceUtils.isInteger((String)value)) {
            return ConverterProvider.createNumber(value).longValue();
        }
        throw new UnableToConvertException(String.format("%s is not a long value", value));
    }

    private static int intValue(String value) throws UnableToConvertException {
        if (TypeInferenceUtils.isInteger((String)value)) {
            return ConverterProvider.createNumber(value).intValue();
        }
        throw new UnableToConvertException(String.format("%s is not an int value", value));
    }

    private static boolean booleanValue(String value) throws UnableToConvertException {
        if (TypeInferenceUtils.isBoolean((String)value)) {
            return Boolean.parseBoolean(value);
        }
        throw new UnableToConvertException(String.format("%s is not a boolean value", value));
    }

    public ConverterProvider put(Class<?> valueClass, Converter converter) {
        this.converters.put(valueClass, converter);
        return this;
    }

    public boolean contains(Class<?> valueClass) {
        return this.findKey(valueClass) != null;
    }

    public Converter get(Class<?> valueClass) {
        return this.converters.get(this.findKey(valueClass));
    }

    private Class<?> findKey(Class<?> valueClass) {
        Class<?> classToCheck;
        for (classToCheck = valueClass; classToCheck != null && !this.converters.containsKey(classToCheck); classToCheck = classToCheck.getSuperclass()) {
        }
        return classToCheck;
    }

    static {
        converterProviders.put(ValueType.STRING, new ConverterProvider().put(Object.class, Object::toString));
        converterProviders.put(ValueType.DOUBLE, new ConverterProvider().put(String.class, ConverterProvider::doubleValue));
        converterProviders.put(ValueType.INTEGER, new ConverterProvider().put(String.class, ConverterProvider::intValue));
        converterProviders.put(ValueType.LONG, new ConverterProvider().put(String.class, ConverterProvider::longValue));
        converterProviders.put(ValueType.FLOAT, new ConverterProvider().put(String.class, ConverterProvider::floatValue));
        converterProviders.put(ValueType.BOOLEAN, new ConverterProvider().put(String.class, ConverterProvider::booleanValue));
        converterProviders.put(ValueType.TIMESTAMP, new ConverterProvider().put(Long.class, new NumberToDateTimeConverter.NumberToDateTime()));
    }
}

