/*
 * Decompiled with CFR 0.152.
 */
package org.talend.trr.runtime.exception;

import java.util.Set;
import org.talend.dataquality.semantic.snapshot.DictionarySnapshot;
import org.talend.trr.runtime.Rule;
import org.talend.trr.runtime.util.SemanticTypeUtils;

public class NonViableRuleException
extends RuntimeException {
    private final Set<String> nonCompleteTypes;
    private final Set<String> deletedTypes;

    public NonViableRuleException(String message, Set<String> nonCompleteTypes, Set<String> deletedTypes) {
        super(message);
        this.nonCompleteTypes = nonCompleteTypes;
        this.deletedTypes = deletedTypes;
    }

    public Set<String> getNonCompleteTypes() {
        return this.nonCompleteTypes;
    }

    public Set<String> getDeletedTypes() {
        return this.deletedTypes;
    }

    public static NonViableRuleException forRule(Rule rule, DictionarySnapshot dictionarySnapshot) {
        Set<String> nonCompleteTypes;
        StringBuilder message = new StringBuilder();
        message.append(String.format("Rule %s non viable.", rule.getId()));
        Set<String> deletedTypes = SemanticTypeUtils.getTypeLabels(rule.getAdvancedExpression(), "DELETED_TYPE__", dictionarySnapshot);
        if (!deletedTypes.isEmpty()) {
            message.append(" Deleted semantic types: ").append(String.join((CharSequence)", ", deletedTypes)).append(".");
        }
        if (!(nonCompleteTypes = SemanticTypeUtils.getTypeLabels(rule.getAdvancedExpression(), "NON_COMPLETE_TYPE__", dictionarySnapshot)).isEmpty()) {
            message.append(" Non-complete semantic types: ").append(String.join((CharSequence)", ", nonCompleteTypes)).append(".");
        }
        return new NonViableRuleException(message.toString(), nonCompleteTypes, deletedTypes);
    }
}

