/*
 * Decompiled with CFR 0.152.
 */
package org.talend.trr.runtime.function;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.talend.maplang.el.interpreter.impl.ExprValueException;
import org.talend.maplang.el.interpreter.impl.function.ExprLangFunctionException;
import org.talend.maplang.el.interpreter.impl.function.builtin.ExtractFromDateTime;
import org.talend.trr.runtime.function.FunctionException;

public abstract class IsInFromDateTime
extends ExtractFromDateTime {
    private final List<List<String>> data = new ArrayList<List<String>>();
    private final String extractPart;

    public IsInFromDateTime(String dataFilename, String extractPart) {
        this.loadData(dataFilename);
        this.extractPart = extractPart;
    }

    public IsInFromDateTime(String extractPart) {
        this.extractPart = extractPart;
    }

    @Override
    public Object call(Object ... params) throws ExprLangFunctionException {
        this.checkNbrOfArguments(params, 2);
        this.checkArgumentsNotNull(params);
        try {
            Integer extractedValue = (Integer)super.call(params[0], this.extractPart);
            if (extractedValue != null) {
                if (NumberUtils.isCreatable(params[1].toString())) {
                    return NumberUtils.createNumber(params[1].toString()).equals(extractedValue);
                }
                if (!this.data.isEmpty()) {
                    List<String> values = this.data.get(extractedValue - 1);
                    return values.contains(params[1].toString().toLowerCase());
                }
            }
        }
        catch (ExprValueException exc) {
            throw new FunctionException(String.format("Cannot parse the datetime argument '%s': %s", params[0], exc.getMessage()));
        }
        return false;
    }

    private void loadData(String filename) {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);
        try (Scanner scanner = new Scanner(is);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (!StringUtils.isNotEmpty(line)) continue;
                this.data.add(Arrays.stream(line.split(";")).map(String::toLowerCase).collect(Collectors.toList()));
            }
        }
    }
}

