/*
 * Decompiled with CFR 0.152.
 */
package org.talend.trr.runtime.model;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class Variable {
    private final String name;
    private final Set<UseContext> usedIn = new HashSet<UseContext>();

    public Variable(String name) {
        this.name = name;
    }

    public Variable usedIn(UseContext ... useContext) {
        this.usedIn.addAll(Arrays.asList(useContext));
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Set<UseContext> getUsedIn() {
        return this.usedIn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Variable variable = (Variable)o;
        return Objects.equals(this.name, variable.name) && Objects.equals(this.usedIn, variable.usedIn);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.usedIn);
    }

    public String toString() {
        return "Variable{name='" + this.name + '\'' + ", usedIn=" + this.usedIn + '}';
    }

    public static enum UseContext {
        CONDITION,
        ACTION;

    }
}

