/*
 * Decompiled with CFR 0.152.
 */
package org.talend.trr.runtime.service;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataquality.semantic.snapshot.DictionarySnapshot;
import org.talend.maplang.el.parser.ExprLangException;
import org.talend.maplang.el.parser.ExprParser;
import org.talend.maplang.el.parser.model.ELNode;
import org.talend.trr.common.utils.VariableHelper;
import org.talend.trr.runtime.Rule;
import org.talend.trr.runtime.exception.NonViableRuleException;
import org.talend.trr.runtime.exception.RuleNotFoundException;
import org.talend.trr.runtime.model.Parameter;
import org.talend.trr.runtime.model.VariableValidationError;
import org.talend.trr.runtime.model.VariableValidationResult;
import org.talend.trr.runtime.service.RuleProvider;
import org.talend.trr.runtime.util.VariableUtils;

public final class RuleChecker {
    private static final Logger log = LoggerFactory.getLogger(RuleChecker.class);

    private RuleChecker() {
    }

    public static VariableValidationResult areVariablesCorrectlySet(Set<String> variables, List<Parameter> parameters) {
        List mappedVars = parameters.stream().map(Parameter::getName).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(variables)) {
            if (CollectionUtils.isEmpty(parameters)) {
                return VariableValidationResult.failure(VariableValidationError.NO_PARAMETER_PROVIDED);
            }
            if (!mappedVars.containsAll(variables)) {
                return VariableValidationResult.failure(VariableValidationError.MISSING_MAPPED_VARIABLE);
            }
            if (!variables.containsAll(mappedVars)) {
                return VariableValidationResult.failure(VariableValidationError.TOO_MANY_MAPPING);
            }
            if (variables.size() != mappedVars.size()) {
                return VariableValidationResult.failure(VariableValidationError.VARIABLE_MAPPED_TWICE);
            }
        }
        return VariableValidationResult.success();
    }

    public static boolean isMappingCompliant(Rule rule, List<Parameter> parameters) {
        try {
            ExprParser parser = VariableHelper.initializeParser();
            ELNode node = parser.parse(rule.getAdvancedExpression());
            Set<String> variables = VariableUtils.extractVariableNames(node);
            return RuleChecker.areVariablesCorrectlySet(variables, parameters).isSuccess();
        }
        catch (ExprLangException e) {
            log.info(String.format("Parsing error for the expression: %s", rule.getAdvancedExpression()), (Object)e.getMessage());
            log.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean isMappingCompliant(RuleProvider ruleProvider, UUID ruleId, Long ruleVersion, List<Parameter> parameters) {
        Rule rule = RuleChecker.getRule(ruleProvider, ruleId, ruleVersion);
        return RuleChecker.isMappingCompliant(rule, parameters);
    }

    public static void checkIfViable(Rule rule, DictionarySnapshot dictionarySnapshot) {
        if (!rule.isViable()) {
            throw NonViableRuleException.forRule(rule, dictionarySnapshot);
        }
    }

    public static void checkIfViable(RuleProvider ruleProvider, UUID ruleId, Long ruleVersion, DictionarySnapshot dictionarySnapshot) {
        Rule rule = RuleChecker.getRule(ruleProvider, ruleId, ruleVersion);
        RuleChecker.checkIfViable(rule, dictionarySnapshot);
    }

    private static Rule getRule(RuleProvider ruleProvider, UUID ruleId, Long ruleVersion) {
        if (ruleProvider == null) {
            throw new IllegalStateException("Rule provider has not been set or is null");
        }
        return ruleProvider.getRule(ruleId, ruleVersion).orElseThrow(() -> new RuleNotFoundException(String.format("Rule id %s not found in version %s", ruleId, ruleVersion)));
    }
}

