/*
 * Decompiled with CFR 0.152.
 */
package org.talend.trr.runtime.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dgp.common.tenantcontext.TenantContext;
import org.talend.trr.runtime.Rule;
import org.talend.trr.runtime.config.CacheConfig;
import org.talend.trr.runtime.model.RuleIdentifier;
import org.talend.tsd.maven.connector.domain.ArtifactDetails;
import org.talend.tsd.maven.connector.service.ArtifactService;
import org.talend.tsd.utils.TemporaryFolder;

public class RuleProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ArtifactService artifactService;
    private final TenantContext tenantContext;
    private final Path extractFolder;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final LoadingCache<RuleIdentifier, Optional<Rule>> cache;

    public RuleProvider(TenantContext tenantContext, ArtifactService artifactService, Path extractFolder) {
        this(tenantContext, artifactService, extractFolder, CacheConfig.NO_CACHE);
    }

    public RuleProvider(TenantContext tenantContext, ArtifactService artifactService, Path extractFolder, CacheConfig cacheConfig) {
        this.tenantContext = tenantContext;
        this.artifactService = artifactService;
        this.extractFolder = extractFolder;
        cacheConfig = cacheConfig == null ? CacheConfig.NO_CACHE : cacheConfig;
        this.cache = Caffeine.newBuilder().recordStats().maximumSize(cacheConfig.getMaximumSize()).expireAfterAccess(cacheConfig.getDuration(), cacheConfig.getDurationUnit()).build(this::getRule);
    }

    public Optional<Rule> getRule(RuleIdentifier ruleIdentifier) {
        return this.findRule(ruleIdentifier.asPredicate(), ruleIdentifier.getVersion());
    }

    public Optional<Rule> getRule(UUID ruleId, Long version) {
        return this.cache.get(new RuleIdentifier(ruleId, version));
    }

    public Optional<Rule> getRule(String ruleName, Long version) {
        return this.cache.get(new RuleIdentifier(ruleName, version));
    }

    public List<Rule> findRules(Long version) {
        String tenantId = this.tenantContext.getCurrentTenantId();
        ArtifactDetails artifactDetails = new ArtifactDetails(tenantId, "rules", version);
        Path newFolder = this.extractFolder.resolve(UUID.randomUUID().toString());
        TemporaryFolder targetFolder = new TemporaryFolder(newFolder);
        try {
            this.artifactService.getAndExtract(artifactDetails, targetFolder);
            File ruleFile = targetFolder.resolve("rules.json").toFile();
            List<Rule> list = Arrays.asList((Rule[])this.objectMapper.readValue(ruleFile, Rule[].class));
            targetFolder.close();
            return list;
        }
        catch (Throwable throwable) {
            try {
                try {
                    targetFolder.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                this.log.warn("Unexpected error when getting and reading rules.json", (Throwable)e);
                throw new RuntimeException("An error occurred while trying to retrieve the rule.", e);
            }
        }
    }

    private Optional<Rule> findRule(Predicate<Rule> predicate, Long version) {
        return this.findRules(version).stream().filter(predicate).findFirst();
    }
}

