/*
 * Decompiled with CFR 0.152.
 */
package org.talend.trr.runtime.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataquality.semantic.model.DQCategory;
import org.talend.dataquality.semantic.snapshot.DictionarySnapshot;
import org.talend.maplang.el.interpreter.api.ExprInterpreterException;
import org.talend.maplang.el.interpreter.impl.ExprValueException;
import org.talend.maplang.el.parser.ExprLangException;
import org.talend.maplang.el.parser.ExprParser;
import org.talend.maplang.el.parser.model.ELNode;
import org.talend.maplang.el.parser.model.ELNodeType;
import org.talend.maplang.hpath.HPathStore;
import org.talend.trr.common.utils.VariableHelper;
import org.talend.trr.runtime.Rule;
import org.talend.trr.runtime.RuleExecution;
import org.talend.trr.runtime.converter.ConverterProvider;
import org.talend.trr.runtime.converter.UnableToConvertException;
import org.talend.trr.runtime.exception.DQCategoryNotFoundException;
import org.talend.trr.runtime.exception.RuleExecutionException;
import org.talend.trr.runtime.function.FunctionException;
import org.talend.trr.runtime.model.DataType;
import org.talend.trr.runtime.model.NativeType;
import org.talend.trr.runtime.model.Parameter;
import org.talend.trr.runtime.service.RuleChecker;
import org.talend.trr.runtime.service.RuleProvider;
import org.talend.trr.runtime.util.SemanticTypeUtils;
import org.talend.trr.runtime.validation.ValidationResult;
import org.talend.trr.runtime.validation.ValidationRuleExecutionResult;

public class ValidationRuleExecution
extends RuleExecution<ValidationRuleExecutionResult> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ValidationRuleExecutionResult executionResult = new ValidationRuleExecutionResult();
    private final Map<String, ConverterProvider> varConverters = new HashMap<String, ConverterProvider>();

    public ValidationRuleExecution(RuleProvider ruleProvider, UUID ruleId, Long version, DictionarySnapshot dictionarySnapshot) throws RuleExecutionException {
        super(ruleProvider, ruleId, version, dictionarySnapshot);
    }

    public ValidationRuleExecution(Rule rule, DictionarySnapshot dictionarySnapshot) throws RuleExecutionException {
        super(rule, dictionarySnapshot);
    }

    @Deprecated
    public ValidationRuleExecution(String tenantId, RuleProvider ruleProvider, UUID ruleId, Long version, DictionarySnapshot dictionarySnapshot) throws RuleExecutionException {
        super(tenantId, ruleProvider, ruleId, version, dictionarySnapshot);
    }

    @Deprecated
    public ValidationRuleExecution(String tenantId, Rule rule, DictionarySnapshot dictionarySnapshot) throws RuleExecutionException {
        super(tenantId, rule, dictionarySnapshot);
    }

    @Override
    public void init(List<String> columnNames, List<Parameter> parameters, Map<String, DataType> types) throws RuleExecutionException {
        super.init(columnNames, parameters, types);
        this.executionResult.init();
        RuleChecker.areVariablesCorrectlySet(this.variables.keySet(), parameters).onErrorThrow(result -> new RuleExecutionException("Variables not correctly set: " + (Object)result));
        try {
            String expression = this.rule.getAdvancedExpression();
            ExprParser parser = VariableHelper.initializeParser();
            ELNode root = parser.parse(expression);
            this.varConverters.clear();
            this.findConverters(root);
            if (expression.contains("isOfType")) {
                this.initAnalyzer(expression, parameters);
            }
        }
        catch (ExprLangException e) {
            throw new RuleExecutionException("Expression parsing error: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean execute(Object ... data) {
        try {
            this.storeVariables(data);
            this.interpreter.setExpression(this.rule.getAdvancedExpression());
            Object evalResult = this.interpreter.eval();
            if (evalResult == null) {
                this.executionResult.addResult(ValidationResult.NOT_APPLICABLE);
            } else if (((Boolean)evalResult).booleanValue()) {
                this.executionResult.addResult(ValidationResult.VALID);
            } else {
                this.executionResult.addResult(ValidationResult.INVALID);
            }
            return true;
        }
        catch (ArithmeticException | ClassCastException | NumberFormatException | ExprInterpreterException | ExprValueException | ExprLangException | FunctionException e) {
            this.log.info("Expression evaluation error: {}", (Object)e.getMessage());
            this.log.debug(e.getMessage(), (Throwable)e);
            this.executionResult.addResult(ValidationResult.NOT_EXECUTABLE);
            return false;
        }
        catch (DQCategoryNotFoundException notFoundException) {
            throw notFoundException;
        }
        catch (Exception e) {
            this.log.error("Unexpected expression evaluation error", (Throwable)e);
            this.executionResult.addResult(ValidationResult.NOT_EXECUTABLE);
            return false;
        }
    }

    private void storeVariables(Object ... data) {
        this.parameters.forEach(parameter -> {
            ConverterProvider converterProvider;
            Object variable = parameter.isColumn() ? data[this.getColumnIndex(parameter.getValue())] : parameter.getValue();
            if (variable != null && this.varConverters.containsKey(parameter.getName()) && (converterProvider = this.varConverters.get(parameter.getName())) != null && converterProvider.contains(variable.getClass())) {
                try {
                    variable = converterProvider.get(variable.getClass()).convert(variable);
                }
                catch (UnableToConvertException e) {
                    this.log.debug(String.format("Cannot convert %s to %s", variable, ((DataType)this.types.get(parameter.getValue())).getType()), (Throwable)e);
                }
            }
            this.interpreter.storeValue(parameter.getName(), variable);
        });
    }

    private DataType findType(String varName, List<Parameter> parameters, Map<String, DataType> types) {
        return parameters.stream().filter(param -> param.getName().equals(varName) && param.isColumn()).findFirst().map(value -> (DataType)types.get(value.getValue())).orElse(null);
    }

    private void findConverters(ELNode node) {
        node.getChildren().forEach(childNode -> {
            if (childNode.getType() == ELNodeType.HPATH || childNode.getType() == ELNodeType.VARIABLE) {
                DataType type;
                String varName = childNode.getImage();
                if (!this.varConverters.containsKey(varName) && (type = this.findType(varName, this.parameters, this.types)) != null) {
                    ConverterProvider converterProvider = ConverterProvider.get(type);
                    this.varConverters.put(varName, converterProvider);
                }
            } else {
                this.findConverters((ELNode)childNode);
            }
        });
    }

    private void initAnalyzer(String advancedExpression, List<Parameter> parameters) {
        Set<Object> unknownSemanticTypes = new HashSet();
        Matcher m = SemanticTypeUtils.ISOFTYPE_PATTERN.matcher(advancedExpression);
        HPathStore store = this.interpreter.getContext().getStore();
        store.put("dictionarySnapshot", this.dictionarySnapshot);
        while (m.find()) {
            String trimmedGroup = m.group(2).trim();
            Optional<Parameter> param = parameters.stream().filter(p -> p.getName().equals(trimmedGroup)).findAny();
            String semanticTypeName = "";
            if (param.isPresent()) {
                if (param.get().isVal()) {
                    semanticTypeName = this.dataTypeNameFromParam(param.get());
                } else {
                    store.put("semanticTypeNameAsColumn", true);
                }
            } else {
                semanticTypeName = StringUtils.strip(trimmedGroup, "\"'");
            }
            if (semanticTypeName.isEmpty()) continue;
            unknownSemanticTypes.addAll(this.listUnknownTypes(parameters, this.dictionarySnapshot, semanticTypeName));
        }
        if (!(unknownSemanticTypes = unknownSemanticTypes.stream().filter(type -> {
            try {
                NativeType.valueOf(type.toUpperCase());
                return false;
            }
            catch (IllegalArgumentException e) {
                return true;
            }
        }).collect(Collectors.toSet())).isEmpty()) {
            throw new DQCategoryNotFoundException("List of unknown semantic types: " + unknownSemanticTypes);
        }
    }

    private String dataTypeNameFromParam(Parameter param) {
        String semanticNameParam = param.getValue();
        Optional<DQCategory> category = this.dictionarySnapshot.getMetadata().values().stream().filter(cat -> cat.getLabel().equals(semanticNameParam)).findFirst();
        String semanticTypeName = category.isPresent() ? category.get().getName() : NativeType.valueOf(semanticNameParam.toUpperCase()).toString();
        this.interpreter.storeValue(semanticNameParam, semanticTypeName);
        return semanticTypeName;
    }

    private List<String> listUnknownTypes(List<Parameter> parameters, DictionarySnapshot dictionarySnapshot, String semanticTypeName) {
        ArrayList<String> unknownSemanticTypes = new ArrayList<String>();
        boolean isAParameter = false;
        for (Parameter parameter : parameters) {
            if (!parameter.getName().equals(semanticTypeName) || !parameter.isVal()) continue;
            isAParameter = true;
            String value = parameter.getValue();
            if (dictionarySnapshot.getCategoryMetadataByName(value) != null) break;
            unknownSemanticTypes.add(value);
            break;
        }
        if (!isAParameter && dictionarySnapshot.getCategoryMetadataByName(semanticTypeName) == null) {
            unknownSemanticTypes.add(semanticTypeName);
        }
        return unknownSemanticTypes;
    }

    @Override
    public ValidationRuleExecutionResult getResults() {
        return this.executionResult;
    }
}

