/*
 * Decompiled with CFR 0.152.
 */
package org.talend.trr.runtime.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntPredicate;
import java.util.stream.IntStream;
import org.talend.dataquality.semantic.snapshot.DictionarySnapshot;
import org.talend.trr.runtime.Rule;
import org.talend.trr.runtime.RuleExecutor;
import org.talend.trr.runtime.exception.RuleExecutionException;
import org.talend.trr.runtime.model.DataType;
import org.talend.trr.runtime.model.Parameter;
import org.talend.trr.runtime.model.Variable;
import org.talend.trr.runtime.util.VariableUtils;
import org.talend.trr.runtime.validation.ValidationResult;
import org.talend.trr.runtime.validation.ValidationRuleExecution;
import org.talend.trr.runtime.validation.ValidationRuleExecutionResult;

public class ValidationRuleExecutor
extends RuleExecutor<ValidationRuleExecution, ValidationRuleExecutionResult, ValidationResult> {
    private final List<ValidationRuleExecutionResult> results = new ArrayList<ValidationRuleExecutionResult>();
    private List<String> columnNames;
    private int nbLines;

    public ValidationRuleExecutor(List<Rule> rules, DictionarySnapshot dictionarySnapshot) throws RuleExecutionException {
        for (Rule rule : rules) {
            this.executions.add(new ValidationRuleExecution(rule, dictionarySnapshot));
        }
    }

    @Override
    public void init(List<String> columnNames, List<List<Parameter>> parameters, Map<String, DataType> types) throws RuleExecutionException {
        this.columnNames = columnNames;
        this.nbLines = 0;
        for (int i = 0; i < parameters.size(); ++i) {
            ((ValidationRuleExecution)this.executions.get(i)).init(columnNames, parameters.get(i), types);
        }
    }

    @Override
    public boolean execute(Object ... data) {
        ++this.nbLines;
        return super.execute(data);
    }

    @Override
    public void end() {
        this.executions.forEach(execution -> this.results.add(execution.getResults()));
    }

    @Override
    public List<ValidationRuleExecutionResult> getResults() {
        return this.results;
    }

    @Override
    public ValidationRuleExecutionResult getResultsByColumn(int columnNumber) {
        return this.getResultsByColumn(this.columnNames.get(columnNumber));
    }

    @Override
    public ValidationRuleExecutionResult getResultsByColumn(int columnNumber, int ruleIndex) {
        return this.getResultsByColumn(this.columnNames.get(columnNumber), ruleIndex);
    }

    @Override
    public ValidationRuleExecutionResult getResultsByColumn(String columnName) {
        return this.getResultsByColumn(columnName, i -> true);
    }

    @Override
    public ValidationRuleExecutionResult getResultsByColumn(String columnName, int ruleIndex) {
        return this.getResultsByColumn(columnName, i -> i == ruleIndex);
    }

    private ValidationRuleExecutionResult getResultsByColumn(String columnName, IntPredicate filterRule) {
        ValidationRuleExecutionResult columnResult = new ValidationRuleExecutionResult();
        IntStream.range(0, this.nbLines).forEach(i -> {
            ValidationRuleExecutionResult lineResults = new ValidationRuleExecutionResult();
            IntStream.range(0, this.executions.size()).filter(filterRule).mapToObj(this.executions::get).forEach(execution -> {
                Optional<Parameter> param;
                Set<String> validationVars = VariableUtils.getVars(execution.getVariables(), Variable.UseContext.ACTION);
                ValidationRuleExecutionResult ruleResults = execution.getResults();
                List<ValidationResult> lineValidationResults = ruleResults.getResults();
                if (i < lineValidationResults.size() && (param = execution.findColumnParameterByValue(columnName)).isPresent() && validationVars.contains(param.get().getName())) {
                    lineResults.addResult(lineValidationResults.get(i));
                }
            });
            columnResult.addResult(lineResults.aggregateResults());
        });
        return columnResult;
    }

    @Override
    public ValidationResult getResultsByLine(int lineNumber) {
        ValidationRuleExecutionResult lineResult = new ValidationRuleExecutionResult();
        for (ValidationRuleExecution execution : this.executions) {
            ValidationRuleExecutionResult ruleResults = execution.getResults();
            List<ValidationResult> lineValidationResults = ruleResults.getResults();
            if (lineNumber >= lineValidationResults.size()) continue;
            lineResult.addResult(lineValidationResults.get(lineNumber));
        }
        return lineResult.aggregateResults();
    }

    @Override
    public ValidationRuleExecutionResult getResultsByRule(int ruleIndex) {
        if (ruleIndex < this.executions.size()) {
            return ((ValidationRuleExecution)this.executions.get(ruleIndex)).getResults();
        }
        return null;
    }

    @Override
    public ValidationResult getResultsByCell(int columnNumber, int lineNumber) {
        ValidationRuleExecutionResult columnResult = this.getResultsByColumn(columnNumber);
        return columnResult.getResults().get(lineNumber);
    }

    @Override
    public ValidationResult getResultsByCell(int columnNumber, int lineNumber, int ruleIndex) {
        ValidationRuleExecutionResult columnResult = this.getResultsByColumn(columnNumber, ruleIndex);
        return columnResult.getResults().get(lineNumber);
    }

    @Override
    public ValidationResult getResultsByCell(String columnName, int lineNumber, int ruleIndex) {
        ValidationRuleExecutionResult columnResult = this.getResultsByColumn(columnName, ruleIndex);
        return columnResult.getResults().get(lineNumber);
    }
}

