/*
 * Decompiled with CFR 0.152.
 */
package org.talend.tsd.artifact.client.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.talend.tsd.artifact.client.ApiClient;
import org.talend.tsd.artifact.client.domain.SemanticBundle;

@Component(value="org.talend.tsd.artifact.client.api.SemanticBundlesApi")
public class SemanticBundlesApi {
    private ApiClient apiClient;

    public SemanticBundlesApi() {
        this(new ApiClient());
    }

    @Autowired
    public SemanticBundlesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public List<SemanticBundle> listSemanticBundles(Integer page, Integer size, Boolean includeInProgress) throws RestClientException {
        return (List)this.listSemanticBundlesWithHttpInfo(page, size, includeInProgress).getBody();
    }

    public ResponseEntity<List<SemanticBundle>> listSemanticBundlesWithHttpInfo(Integer page, Integer size, Boolean includeInProgress) throws RestClientException {
        Object postBody = null;
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "size", size));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "includeInProgress", includeInProgress));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<List<SemanticBundle>> returnType = new ParameterizedTypeReference<List<SemanticBundle>>(){};
        return this.apiClient.invokeAPI("/semantic-bundles", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public void preSignedUrl(Long version) throws RestClientException {
        this.preSignedUrlWithHttpInfo(version);
    }

    public ResponseEntity<Void> preSignedUrlWithHttpInfo(Long version) throws RestClientException {
        Object postBody = null;
        if (version == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'version' when calling preSignedUrl");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("version", version);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<Void> returnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/semantic-bundles/{version}/presignedUrl", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }
}

