/*
 * Decompiled with CFR 0.152.
 */
package org.talend.tsd.dictionary.provider.service;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.RemovalListener;
import io.prometheus.client.cache.caffeine.CacheMetricsCollector;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.talend.dataquality.semantic.api.DeletableDictionarySnapshotOpener;
import org.talend.dataquality.semantic.snapshot.DeletableDictionarySnapshot;
import org.talend.tsd.dictionary.provider.config.DictionaryProviderProperties;
import org.talend.tsd.dictionary.provider.service.IndexFolderProvider;
import org.talend.tsd.maven.connector.domain.SemanticArtifactDetails;
import org.talend.tsd.maven.connector.service.ArtifactService;
import org.talend.tsd.utils.CacheProperties;
import org.talend.tsd.utils.TemporaryFolder;

public abstract class CachedDictionaryProvider {
    private final ArtifactService artifactService;
    private final DictionaryProviderProperties properties;
    private final LoadingCache<SemanticArtifactDetails, DeletableDictionarySnapshot> cache;
    private final IndexFolderProvider indexFolderProvider;
    private final DeletableDictionarySnapshotOpener dictionarySnapshotOpener;

    public CachedDictionaryProvider(ArtifactService artifactService, DictionaryProviderProperties properties, IndexFolderProvider indexFolderProvider, DeletableDictionarySnapshotOpener dictionarySnapshotOpener) {
        this.artifactService = artifactService;
        this.properties = properties;
        this.dictionarySnapshotOpener = dictionarySnapshotOpener;
        RemovalListener<SemanticArtifactDetails, DeletableDictionarySnapshot> removeListener = (key, value, cause) -> value.delete();
        CacheProperties cacheProp = properties.getIndexCache();
        CacheProperties.DurationProperty cacheExpiration = cacheProp.getExpiration();
        this.cache = Caffeine.newBuilder().recordStats().maximumSize(cacheProp.getSize()).expireAfterAccess(cacheExpiration.getDuration(), cacheExpiration.getUnit()).removalListener(removeListener).build(this::fromMaven);
        this.indexFolderProvider = indexFolderProvider;
    }

    public DeletableDictionarySnapshot getBy(@Nonnull String tenantId, @Nullable Long version) {
        SemanticArtifactDetails artifactDetails = new SemanticArtifactDetails(tenantId, version);
        return this.cache.get(artifactDetails).bind();
    }

    public DeletableDictionarySnapshot getDefault(@Nonnull String tenantId) {
        return this.getBy(tenantId, null);
    }

    private DeletableDictionarySnapshot fromMaven(SemanticArtifactDetails artifactDetails) {
        String dictFolder = this.indexFolderProvider.nextFolder(artifactDetails);
        this.retrieveCustomDict(artifactDetails, dictFolder);
        return this.dictionarySnapshotOpener.openDeletableDictionarySnapshot(dictFolder);
    }

    private void retrieveCustomDict(SemanticArtifactDetails artifactDetails, String dictFolder) {
        if (null != artifactDetails.getVersion()) {
            Path targetFolder = Paths.get(this.properties.getIndexFolder(), dictFolder);
            this.artifactService.getAndExtract(artifactDetails, new TemporaryFolder(targetFolder));
        }
    }

    public void register(CacheMetricsCollector collector) {
        collector.addCache("tsd.index.cache", this.cache);
    }

    public void clearCache() {
        this.cache.invalidateAll();
    }
}

