/*
 * Decompiled with CFR 0.152.
 */
package org.talend.tsd.maven.connector.resttemplate.client;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.jar.JarFile;
import javax.annotation.Nonnull;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StreamUtils;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestTemplate;
import org.talend.tsd.artifact.client.api.SemanticBundlesApi;
import org.talend.tsd.maven.connector.exception.JarException;
import org.talend.tsd.maven.connector.resttemplate.config.RestTemplateConnectorProperties;
import org.talend.tsd.maven.connector.resttemplate.exception.JarDownloadException;

public class HttpClient {
    private final RestTemplate restTemplate;
    private final RestTemplateConnectorProperties properties;
    private final SemanticBundlesApi semanticBundlesApi;

    public HttpClient(RestTemplate restTemplate, RestTemplateConnectorProperties properties, SemanticBundlesApi semanticBundlesApi) {
        this.restTemplate = restTemplate;
        this.properties = properties;
        this.semanticBundlesApi = semanticBundlesApi;
    }

    public JarFile download(String preSigned, @Nonnull Path tmpFolder) {
        Path destinationFile = tmpFolder.resolve("semanticIndex.jar");
        this.ensureParentFolderExist(destinationFile);
        try {
            File file = this.restTemplate.execute(preSigned, HttpMethod.GET, this.getRequestCallback(this.properties.getPat()), this.fileResponseExtractor(destinationFile), new Object[0]);
            return this.toJarFile(file);
        }
        catch (Exception e) {
            throw new JarDownloadException(e);
        }
    }

    private RequestCallback getRequestCallback(String bearer) {
        return request -> request.getHeaders().setBearerAuth(bearer);
    }

    private ResponseExtractor<File> fileResponseExtractor(Path destinationFile) {
        return clientHttpResponse -> {
            File ret = Files.createFile(destinationFile, new FileAttribute[0]).toFile();
            try (FileOutputStream out = new FileOutputStream(ret);){
                StreamUtils.copy((InputStream)clientHttpResponse.getBody(), (OutputStream)out);
            }
            return ret;
        };
    }

    private JarFile toJarFile(File file) throws IOException {
        if (null == file) {
            throw new JarDownloadException("Failed to download");
        }
        return new JarFile(file);
    }

    private void ensureParentFolderExist(Path jarFile) {
        Path parentFolder = jarFile.getParent();
        if (!Files.exists(parentFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(parentFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new JarException("Can't create parent folder", e);
            }
        }
    }

    public URI getPreSigned(long version) {
        ResponseEntity<Void> response = this.semanticBundlesApi.preSignedUrlWithHttpInfo(version);
        return response.getHeaders().getLocation();
    }
}

