/*
 * Decompiled with CFR 0.152.
 */
package org.talend.tsd.maven.connector.resttemplate.config;

import javax.annotation.Nonnull;
import javax.validation.constraints.NotBlank;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConstructorBinding;
import org.springframework.boot.context.properties.bind.DefaultValue;
import org.springframework.validation.annotation.Validated;
import org.talend.tsd.maven.connector.config.ConnectorProperties;

@Validated
@ConfigurationProperties(prefix="tsd.resttemplate.connector")
@ConstructorBinding
public class RestTemplateConnectorProperties
extends ConnectorProperties {
    private final boolean enabled;
    @NotBlank
    private String producerUrl;
    private String dqRulesUrl;
    @NotBlank
    private String pat;

    public RestTemplateConnectorProperties(@Nonnull String temporaryFolder, @DefaultValue(value={"false"}) boolean enabled, @Nonnull String producerUrl, @Nonnull String dqRulesUrl, @Nonnull String pat) {
        super(temporaryFolder);
        this.enabled = enabled;
        this.producerUrl = producerUrl;
        this.dqRulesUrl = this.cleanDqRulesForRetroCompatibilityStudio(dqRulesUrl);
        this.pat = pat;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getProducerUrl() {
        return this.producerUrl;
    }

    public void setProducerUrl(String producerUrl) {
        this.producerUrl = producerUrl;
    }

    public String getPat() {
        return this.pat;
    }

    public void setPat(String pat) {
        this.pat = pat;
    }

    public String getDqRulesUrl() {
        return this.dqRulesUrl;
    }

    public void setDqRulesUrl(String dqRulesUrl) {
        this.dqRulesUrl = dqRulesUrl;
    }

    private String cleanDqRulesForRetroCompatibilityStudio(String url) {
        if (url.endsWith("/api/v1")) {
            return url.replace("/api/v1", "");
        }
        return url;
    }
}

