/*
 * Decompiled with CFR 0.152.
 */
package org.talend.tsd.maven.connector.resttemplate.service;

import java.nio.file.Path;
import java.util.jar.JarFile;
import javax.annotation.Nonnull;
import org.talend.tsd.maven.connector.domain.ArtifactDetails;
import org.talend.tsd.maven.connector.repository.JarClient;
import org.talend.tsd.maven.connector.resttemplate.client.HttpClient;
import org.talend.tsd.maven.connector.resttemplate.config.RestTemplateConnectorProperties;

public class RestTemplateJarClient
implements JarClient {
    private final HttpClient client;
    private final RestTemplateConnectorProperties properties;

    public RestTemplateJarClient(HttpClient client, RestTemplateConnectorProperties properties) {
        this.client = client;
        this.properties = properties;
    }

    @Override
    public JarFile findOne(@Nonnull ArtifactDetails artifactDetails, @Nonnull Path temporaryFolder) {
        String preSigned = this.selectPreSigned(artifactDetails);
        return this.client.download(preSigned, temporaryFolder);
    }

    private String selectPreSigned(ArtifactDetails artifactDetails) {
        switch (artifactDetails.getArtifactId()) {
            case "rules": {
                return this.properties.getDqRulesUrl() + "/api/v1/rule-bundles/" + artifactDetails.getVersion() + "/presignedUrl";
            }
        }
        return this.properties.getProducerUrl() + "/semantic-bundles/" + artifactDetails.getVersion() + "/presignedUrl";
    }

    @Override
    public void publish(@Nonnull ArtifactDetails artifactDetails, @Nonnull Path jarPath, @Nonnull Path temporaryFolder) {
        throw new RuntimeException("Not implemented");
    }
}

