/*
 * Decompiled with CFR 0.152.
 */
package org.talend.tsd.maven.connector.service;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicLong;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.tsd.maven.connector.config.ConnectorProperties;
import org.talend.tsd.maven.connector.domain.ArtifactDetails;
import org.talend.tsd.maven.connector.exception.JarException;
import org.talend.tsd.maven.connector.repository.JarClient;
import org.talend.tsd.maven.connector.service.JarService;
import org.talend.tsd.utils.RandomFolderNameProvider;
import org.talend.tsd.utils.TemporaryFolder;

public abstract class ArtifactService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final JarService jarService;
    private final ConnectorProperties properties;
    private final JarClient jarClient;
    private final RandomFolderNameProvider randomFolderNameProvider;
    private final AtomicLong jarSizeMetric;

    public ArtifactService(JarService jarService, ConnectorProperties properties, JarClient jarClient, RandomFolderNameProvider randomFolderNameProvider, MeterRegistry meterRegistry) {
        this.jarService = jarService;
        this.properties = properties;
        this.jarClient = jarClient;
        this.randomFolderNameProvider = randomFolderNameProvider;
        this.jarSizeMetric = meterRegistry != null ? meterRegistry.gauge("tsd_jar_size", new AtomicLong(0L)) : new AtomicLong(0L);
    }

    public void packageAndPush(ArtifactDetails artifactDetails, Path contentFolder) {
        this.log.debug("Package and publish {} - {}", (Object)artifactDetails, (Object)contentFolder);
        try (TemporaryFolder temporaryFolder = this.randomFolderNameProvider.newOne(this.properties.getTemporaryRepoFolder());){
            Path jarFile = temporaryFolder.resolve(artifactDetails.getGroupId() + "-" + artifactDetails.getVersion() + ".jar");
            this.jarService.toJar(jarFile, contentFolder);
            this.publishJar(artifactDetails, jarFile, temporaryFolder);
        }
    }

    public void publishJar(ArtifactDetails artifactDetails, Path jarFile, TemporaryFolder temporaryFolder) {
        this.jarClient.publish(artifactDetails, jarFile, temporaryFolder.asPath());
        try (FileChannel jar = FileChannel.open(jarFile, new OpenOption[0]);){
            this.jarSizeMetric.set(jar.size());
        }
        catch (IOException e) {
            this.log.error("File not found, no metrics to push.", (Throwable)e);
        }
    }

    public void uploadJar(ArtifactDetails artifactDetails, Path jarFile, TemporaryFolder temporaryFolder) {
        this.publishJar(artifactDetails, jarFile, temporaryFolder);
    }

    @Timed(value="tsd_get_and_extract")
    public void getAndExtract(ArtifactDetails artifactDetails, TemporaryFolder targetFolder) {
        this.log.debug("Download artifact " + artifactDetails);
        if (this.properties.useFolderAsM2) {
            this.useM2(artifactDetails, targetFolder);
        } else {
            this.useTemporaryFolder(artifactDetails, targetFolder);
        }
    }

    private void useTemporaryFolder(ArtifactDetails artifactDetails, TemporaryFolder targetFolder) {
        try (TemporaryFolder temporaryFolder = this.randomFolderNameProvider.newOne(this.properties.getTemporaryRepoFolder());
             JarFile jar = this.jarClient.findOne(artifactDetails, temporaryFolder.asPath());){
            this.jarService.extract(jar, targetFolder.asPath());
        }
        catch (IOException e) {
            this.log.error("Jar access error", (Throwable)e);
            throw new JarException("Jar access error", e);
        }
    }

    public Path downloadJar(ArtifactDetails artifactDetails, TemporaryFolder targetFolder) {
        String name = this.download(artifactDetails, targetFolder);
        Path jarPath = targetFolder.resolve(artifactDetails.getGroupId() + "-" + artifactDetails.getVersion() + ".jar");
        Path sourceFile = Paths.get(name, new String[0]);
        try {
            Path ret = Files.move(sourceFile, jarPath, new CopyOption[0]);
            this.log.debug("Successfully copied jar file in path" + ret);
            return jarPath;
        }
        catch (IOException e) {
            this.log.error("Copy of jar has failed", (Throwable)e);
            throw new JarException("Copy of jar has failed", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String download(ArtifactDetails artifactDetails, TemporaryFolder targetFolder) {
        try (JarFile jar = this.jarClient.findOne(artifactDetails, targetFolder.asPath());){
            String string = jar.getName();
            return string;
        }
        catch (IOException e) {
            this.log.error("Downloading of jar has failed", (Throwable)e);
            throw new JarException("Downloading of jar has failed", e);
        }
    }

    private void useM2(ArtifactDetails artifactDetails, TemporaryFolder targetFolder) {
        Path m2Path = Paths.get(this.properties.getTemporaryRepoFolder(), new String[0]).resolve("m2");
        try (TemporaryFolder temporaryFolder = new TemporaryFolder(m2Path);
             JarFile jar = this.jarClient.findOne(artifactDetails, temporaryFolder.asPath());){
            this.jarService.extract(jar, targetFolder.asPath());
        }
        catch (IOException e) {
            this.log.error("Jar access error", (Throwable)e);
            throw new JarException("Jar access error", e);
        }
    }
}

