/*
 * Decompiled with CFR 0.152.
 */
package org.talend.tsd.utils;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;

public class CacheProperties {
    @NotNull
    private Long size = 50L;
    private DurationProperty expiration = new DurationProperty(10L, TimeUnit.MINUTES);

    public CacheProperties() {
    }

    public CacheProperties(Long size, DurationProperty expiration) {
        this.size = size;
        this.expiration = expiration;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public DurationProperty getExpiration() {
        return this.expiration;
    }

    public void setExpiration(DurationProperty expiration) {
        this.expiration = expiration;
    }

    public String toString() {
        return "CacheProperties{size=" + this.size + ", expiration=" + this.expiration + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheProperties that = (CacheProperties)o;
        return this.size == that.size && Objects.equals(this.expiration, that.expiration);
    }

    public int hashCode() {
        return Objects.hash(this.size, this.expiration);
    }

    public static class DurationProperty {
        @NotNull
        private Long duration;
        @NotNull
        private TimeUnit unit;

        public DurationProperty() {
        }

        public DurationProperty(Long duration, TimeUnit unit) {
            this.duration = duration;
            this.unit = unit;
        }

        public Long getDuration() {
            return this.duration;
        }

        public void setDuration(long duration) {
            this.duration = duration;
        }

        public TimeUnit getUnit() {
            return this.unit;
        }

        public void setUnit(TimeUnit unit) {
            this.unit = unit;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DurationProperty that = (DurationProperty)o;
            return this.duration == that.duration && this.unit == that.unit;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.duration, this.unit});
        }

        public String toString() {
            return "DurationProperty{duration=" + this.duration + ", unit=" + (Object)((Object)this.unit) + '}';
        }
    }
}

