package ch.rasc.sse.eventbus;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link SseEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new SseEvent.Builder()}.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "SseEvent"})
final class ImmutableSseEvent implements SseEvent {
  private final Set<String> clientIds;
  private final Set<String> excludeClientIds;
  private final Class<?> jsonView;
  private final String event;
  private final Object data;
  private final Duration retry;
  private final String id;
  private final String comment;

  private ImmutableSseEvent(ImmutableSseEvent.Builder builder) {
    this.clientIds = createUnmodifiableSet(builder.clientIds);
    this.excludeClientIds = createUnmodifiableSet(builder.excludeClientIds);
    this.jsonView = builder.jsonView;
    this.data = builder.data;
    this.retry = builder.retry;
    this.id = builder.id;
    this.comment = builder.comment;
    this.event = builder.event != null
        ? builder.event
        : Objects.requireNonNull(SseEvent.super.event(), "event");
  }

  private ImmutableSseEvent(
      Set<String> clientIds,
      Set<String> excludeClientIds,
      Class<?> jsonView,
      String event,
      Object data,
      Duration retry,
      String id,
      String comment) {
    this.clientIds = clientIds;
    this.excludeClientIds = excludeClientIds;
    this.jsonView = jsonView;
    this.event = event;
    this.data = data;
    this.retry = retry;
    this.id = id;
    this.comment = comment;
  }

  /**
   * @return The value of the {@code clientIds} attribute
   */
  @Override
  public Set<String> clientIds() {
    return clientIds;
  }

  /**
   * @return The value of the {@code excludeClientIds} attribute
   */
  @Override
  public Set<String> excludeClientIds() {
    return excludeClientIds;
  }

  /**
   * @return The value of the {@code jsonView} attribute
   */
  @Override
  public Optional<Class<?>> jsonView() {
    return Optional.ofNullable(jsonView);
  }

  /**
   * @return The value of the {@code event} attribute
   */
  @Override
  public String event() {
    return event;
  }

  /**
   * @return The value of the {@code data} attribute
   */
  @Override
  public Object data() {
    return data;
  }

  /**
   * @return The value of the {@code retry} attribute
   */
  @Override
  public Optional<Duration> retry() {
    return Optional.ofNullable(retry);
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public Optional<String> id() {
    return Optional.ofNullable(id);
  }

  /**
   * @return The value of the {@code comment} attribute
   */
  @Override
  public Optional<String> comment() {
    return Optional.ofNullable(comment);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SseEvent#clientIds() clientIds}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSseEvent withClientIds(String... elements) {
    Set<String> newValue = createUnmodifiableSet(createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableSseEvent(
        newValue,
        this.excludeClientIds,
        this.jsonView,
        this.event,
        this.data,
        this.retry,
        this.id,
        this.comment);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SseEvent#clientIds() clientIds}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of clientIds elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSseEvent withClientIds(Iterable<String> elements) {
    if (this.clientIds == elements) return this;
    Set<String> newValue = createUnmodifiableSet(createSafeList(elements, true, false));
    return new ImmutableSseEvent(
        newValue,
        this.excludeClientIds,
        this.jsonView,
        this.event,
        this.data,
        this.retry,
        this.id,
        this.comment);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SseEvent#excludeClientIds() excludeClientIds}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSseEvent withExcludeClientIds(String... elements) {
    Set<String> newValue = createUnmodifiableSet(createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableSseEvent(
        this.clientIds,
        newValue,
        this.jsonView,
        this.event,
        this.data,
        this.retry,
        this.id,
        this.comment);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SseEvent#excludeClientIds() excludeClientIds}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of excludeClientIds elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSseEvent withExcludeClientIds(Iterable<String> elements) {
    if (this.excludeClientIds == elements) return this;
    Set<String> newValue = createUnmodifiableSet(createSafeList(elements, true, false));
    return new ImmutableSseEvent(
        this.clientIds,
        newValue,
        this.jsonView,
        this.event,
        this.data,
        this.retry,
        this.id,
        this.comment);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SseEvent#jsonView() jsonView} attribute.
   * @param value The value for jsonView
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSseEvent withJsonView(Class<?> value) {
    Class<?> newValue = Objects.requireNonNull(value, "jsonView");
    if (this.jsonView == newValue) return this;
    return new ImmutableSseEvent(
        this.clientIds,
        this.excludeClientIds,
        newValue,
        this.event,
        this.data,
        this.retry,
        this.id,
        this.comment);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SseEvent#jsonView() jsonView} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for jsonView
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSseEvent withJsonView(Optional<? extends Class<?>> optional) {
    Class<?> value = optional.orElse(null);
    if (this.jsonView == value) return this;
    return new ImmutableSseEvent(
        this.clientIds,
        this.excludeClientIds,
        value,
        this.event,
        this.data,
        this.retry,
        this.id,
        this.comment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SseEvent#event() event} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for event
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSseEvent withEvent(String value) {
    if (this.event.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "event");
    return new ImmutableSseEvent(
        this.clientIds,
        this.excludeClientIds,
        this.jsonView,
        newValue,
        this.data,
        this.retry,
        this.id,
        this.comment);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SseEvent#data() data} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for data
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSseEvent withData(Object value) {
    if (this.data == value) return this;
    Object newValue = Objects.requireNonNull(value, "data");
    return new ImmutableSseEvent(
        this.clientIds,
        this.excludeClientIds,
        this.jsonView,
        this.event,
        newValue,
        this.retry,
        this.id,
        this.comment);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SseEvent#retry() retry} attribute.
   * @param value The value for retry
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSseEvent withRetry(Duration value) {
    Duration newValue = Objects.requireNonNull(value, "retry");
    if (this.retry == newValue) return this;
    return new ImmutableSseEvent(
        this.clientIds,
        this.excludeClientIds,
        this.jsonView,
        this.event,
        this.data,
        newValue,
        this.id,
        this.comment);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SseEvent#retry() retry} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for retry
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSseEvent withRetry(Optional<? extends Duration> optional) {
    Duration value = optional.orElse(null);
    if (this.retry == value) return this;
    return new ImmutableSseEvent(
        this.clientIds,
        this.excludeClientIds,
        this.jsonView,
        this.event,
        this.data,
        value,
        this.id,
        this.comment);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SseEvent#id() id} attribute.
   * @param value The value for id
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSseEvent withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (Objects.equals(this.id, newValue)) return this;
    return new ImmutableSseEvent(
        this.clientIds,
        this.excludeClientIds,
        this.jsonView,
        this.event,
        this.data,
        this.retry,
        newValue,
        this.comment);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SseEvent#id() id} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for id
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSseEvent withId(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableSseEvent(
        this.clientIds,
        this.excludeClientIds,
        this.jsonView,
        this.event,
        this.data,
        this.retry,
        value,
        this.comment);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SseEvent#comment() comment} attribute.
   * @param value The value for comment
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSseEvent withComment(String value) {
    String newValue = Objects.requireNonNull(value, "comment");
    if (Objects.equals(this.comment, newValue)) return this;
    return new ImmutableSseEvent(
        this.clientIds,
        this.excludeClientIds,
        this.jsonView,
        this.event,
        this.data,
        this.retry,
        this.id,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SseEvent#comment() comment} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for comment
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSseEvent withComment(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.comment, value)) return this;
    return new ImmutableSseEvent(
        this.clientIds,
        this.excludeClientIds,
        this.jsonView,
        this.event,
        this.data,
        this.retry,
        this.id,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSseEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSseEvent
        && equalTo((ImmutableSseEvent) another);
  }

  private boolean equalTo(ImmutableSseEvent another) {
    return clientIds.equals(another.clientIds)
        && excludeClientIds.equals(another.excludeClientIds)
        && Objects.equals(jsonView, another.jsonView)
        && event.equals(another.event)
        && data.equals(another.data)
        && Objects.equals(retry, another.retry)
        && Objects.equals(id, another.id)
        && Objects.equals(comment, another.comment);
  }

  /**
   * Computes a hash code from attributes: {@code clientIds}, {@code excludeClientIds}, {@code jsonView}, {@code event}, {@code data}, {@code retry}, {@code id}, {@code comment}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + clientIds.hashCode();
    h += (h << 5) + excludeClientIds.hashCode();
    h += (h << 5) + Objects.hashCode(jsonView);
    h += (h << 5) + event.hashCode();
    h += (h << 5) + data.hashCode();
    h += (h << 5) + Objects.hashCode(retry);
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(comment);
    return h;
  }

  /**
   * Prints the immutable value {@code SseEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("SseEvent{");
    builder.append("clientIds=").append(clientIds);
    builder.append(", ");
    builder.append("excludeClientIds=").append(excludeClientIds);
    if (jsonView != null) {
      builder.append(", ");
      builder.append("jsonView=").append(jsonView);
    }
    builder.append(", ");
    builder.append("event=").append(event);
    builder.append(", ");
    builder.append("data=").append(data);
    if (retry != null) {
      builder.append(", ");
      builder.append("retry=").append(retry);
    }
    if (id != null) {
      builder.append(", ");
      builder.append("id=").append(id);
    }
    if (comment != null) {
      builder.append(", ");
      builder.append("comment=").append(comment);
    }
    return builder.append("}").toString();
  }

  /**
   * Creates an immutable copy of a {@link SseEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SseEvent instance
   */
  public static ImmutableSseEvent copyOf(SseEvent instance) {
    if (instance instanceof ImmutableSseEvent) {
      return (ImmutableSseEvent) instance;
    }
    return new SseEvent.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableSseEvent ImmutableSseEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static class Builder {
    private static final long INIT_BIT_DATA = 0x1L;
    private long initBits = 0x1L;

    private List<String> clientIds = new ArrayList<String>();
    private List<String> excludeClientIds = new ArrayList<String>();
    private Class<?> jsonView;
    private String event;
    private Object data;
    private Duration retry;
    private String id;
    private String comment;

    /**
     * Creates a builder for {@link ImmutableSseEvent ImmutableSseEvent} instances.
     */
    public Builder() {
      if (!(this instanceof SseEvent.Builder)) {
        throw new UnsupportedOperationException("Use: new SseEvent.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code SseEvent} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final SseEvent.Builder from(SseEvent instance) {
      Objects.requireNonNull(instance, "instance");
      addAllClientIds(instance.clientIds());
      addAllExcludeClientIds(instance.excludeClientIds());
      Optional<Class<?>> jsonViewOptional = instance.jsonView();
      if (jsonViewOptional.isPresent()) {
        jsonView(jsonViewOptional);
      }
      event(instance.event());
      data(instance.data());
      Optional<Duration> retryOptional = instance.retry();
      if (retryOptional.isPresent()) {
        retry(retryOptional);
      }
      Optional<String> idOptional = instance.id();
      if (idOptional.isPresent()) {
        id(idOptional);
      }
      Optional<String> commentOptional = instance.comment();
      if (commentOptional.isPresent()) {
        comment(commentOptional);
      }
      return (SseEvent.Builder) this;
    }

    /**
     * Adds one element to {@link SseEvent#clientIds() clientIds} set.
     * @param element A clientIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final SseEvent.Builder addClientId(String element) {
      this.clientIds.add(Objects.requireNonNull(element, "clientIds element"));
      return (SseEvent.Builder) this;
    }

    /**
     * Adds elements to {@link SseEvent#clientIds() clientIds} set.
     * @param elements An array of clientIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final SseEvent.Builder addClientId(String... elements) {
      for (String element : elements) {
        this.clientIds.add(Objects.requireNonNull(element, "clientIds element"));
      }
      return (SseEvent.Builder) this;
    }

    /**
     * Sets or replaces all elements for {@link SseEvent#clientIds() clientIds} set.
     * @param elements An iterable of clientIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final SseEvent.Builder clientIds(Iterable<String> elements) {
      this.clientIds.clear();
      return addAllClientIds(elements);
    }

    /**
     * Adds elements to {@link SseEvent#clientIds() clientIds} set.
     * @param elements An iterable of clientIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final SseEvent.Builder addAllClientIds(Iterable<String> elements) {
      for (String element : elements) {
        this.clientIds.add(Objects.requireNonNull(element, "clientIds element"));
      }
      return (SseEvent.Builder) this;
    }

    /**
     * Adds one element to {@link SseEvent#excludeClientIds() excludeClientIds} set.
     * @param element A excludeClientIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final SseEvent.Builder addExcludeClientId(String element) {
      this.excludeClientIds.add(Objects.requireNonNull(element, "excludeClientIds element"));
      return (SseEvent.Builder) this;
    }

    /**
     * Adds elements to {@link SseEvent#excludeClientIds() excludeClientIds} set.
     * @param elements An array of excludeClientIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final SseEvent.Builder addExcludeClientId(String... elements) {
      for (String element : elements) {
        this.excludeClientIds.add(Objects.requireNonNull(element, "excludeClientIds element"));
      }
      return (SseEvent.Builder) this;
    }

    /**
     * Sets or replaces all elements for {@link SseEvent#excludeClientIds() excludeClientIds} set.
     * @param elements An iterable of excludeClientIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final SseEvent.Builder excludeClientIds(Iterable<String> elements) {
      this.excludeClientIds.clear();
      return addAllExcludeClientIds(elements);
    }

    /**
     * Adds elements to {@link SseEvent#excludeClientIds() excludeClientIds} set.
     * @param elements An iterable of excludeClientIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final SseEvent.Builder addAllExcludeClientIds(Iterable<String> elements) {
      for (String element : elements) {
        this.excludeClientIds.add(Objects.requireNonNull(element, "excludeClientIds element"));
      }
      return (SseEvent.Builder) this;
    }

    /**
     * Initializes the optional value {@link SseEvent#jsonView() jsonView} to jsonView.
     * @param jsonView The value for jsonView
     * @return {@code this} builder for chained invocation
     */
    public final SseEvent.Builder jsonView(Class<?> jsonView) {
      this.jsonView = Objects.requireNonNull(jsonView, "jsonView");
      return (SseEvent.Builder) this;
    }

    /**
     * Initializes the optional value {@link SseEvent#jsonView() jsonView} to jsonView.
     * @param jsonView The value for jsonView
     * @return {@code this} builder for use in a chained invocation
     */
    public final SseEvent.Builder jsonView(Optional<? extends Class<?>> jsonView) {
      this.jsonView = jsonView.orElse(null);
      return (SseEvent.Builder) this;
    }

    /**
     * Initializes the value for the {@link SseEvent#event() event} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SseEvent#event() event}.</em>
     * @param event The value for event 
     * @return {@code this} builder for use in a chained invocation
     */
    public final SseEvent.Builder event(String event) {
      this.event = Objects.requireNonNull(event, "event");
      return (SseEvent.Builder) this;
    }

    /**
     * Initializes the value for the {@link SseEvent#data() data} attribute.
     * @param data The value for data 
     * @return {@code this} builder for use in a chained invocation
     */
    public final SseEvent.Builder data(Object data) {
      this.data = Objects.requireNonNull(data, "data");
      initBits &= ~INIT_BIT_DATA;
      return (SseEvent.Builder) this;
    }

    /**
     * Initializes the optional value {@link SseEvent#retry() retry} to retry.
     * @param retry The value for retry
     * @return {@code this} builder for chained invocation
     */
    public final SseEvent.Builder retry(Duration retry) {
      this.retry = Objects.requireNonNull(retry, "retry");
      return (SseEvent.Builder) this;
    }

    /**
     * Initializes the optional value {@link SseEvent#retry() retry} to retry.
     * @param retry The value for retry
     * @return {@code this} builder for use in a chained invocation
     */
    public final SseEvent.Builder retry(Optional<? extends Duration> retry) {
      this.retry = retry.orElse(null);
      return (SseEvent.Builder) this;
    }

    /**
     * Initializes the optional value {@link SseEvent#id() id} to id.
     * @param id The value for id
     * @return {@code this} builder for chained invocation
     */
    public final SseEvent.Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return (SseEvent.Builder) this;
    }

    /**
     * Initializes the optional value {@link SseEvent#id() id} to id.
     * @param id The value for id
     * @return {@code this} builder for use in a chained invocation
     */
    public final SseEvent.Builder id(Optional<String> id) {
      this.id = id.orElse(null);
      return (SseEvent.Builder) this;
    }

    /**
     * Initializes the optional value {@link SseEvent#comment() comment} to comment.
     * @param comment The value for comment
     * @return {@code this} builder for chained invocation
     */
    public final SseEvent.Builder comment(String comment) {
      this.comment = Objects.requireNonNull(comment, "comment");
      return (SseEvent.Builder) this;
    }

    /**
     * Initializes the optional value {@link SseEvent#comment() comment} to comment.
     * @param comment The value for comment
     * @return {@code this} builder for use in a chained invocation
     */
    public final SseEvent.Builder comment(Optional<String> comment) {
      this.comment = comment.orElse(null);
      return (SseEvent.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableSseEvent ImmutableSseEvent}.
     * @return An immutable instance of SseEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSseEvent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSseEvent(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_DATA) != 0) attributes.add("data");
      return "Cannot build SseEvent, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  /** Unmodifiable set constructed from list to avoid rehashing. */
  private static <T> Set<T> createUnmodifiableSet(List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default:
      Set<T> set = new LinkedHashSet<T>(list.size());
      set.addAll(list);
      return Collections.unmodifiableSet(set);
    }
  }
}
