/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.simplesystemsmanagement.model.AssociationOverview;
import com.amazonaws.services.simplesystemsmanagement.model.Target;
import com.amazonaws.services.simplesystemsmanagement.model.transform.AssociationMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class Association
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String instanceId;
    private String associationId;
    private String associationVersion;
    private String documentVersion;
    private SdkInternalList<Target> targets;
    private Date lastExecutionDate;
    private AssociationOverview overview;
    private String scheduleExpression;
    private String associationName;
    private Integer scheduleOffset;
    private Integer duration;
    private SdkInternalList<Map<String, List<String>>> targetMaps;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Association withName(String name) {
        this.setName(name);
        return this;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public Association withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public void setAssociationId(String associationId) {
        this.associationId = associationId;
    }

    public String getAssociationId() {
        return this.associationId;
    }

    public Association withAssociationId(String associationId) {
        this.setAssociationId(associationId);
        return this;
    }

    public void setAssociationVersion(String associationVersion) {
        this.associationVersion = associationVersion;
    }

    public String getAssociationVersion() {
        return this.associationVersion;
    }

    public Association withAssociationVersion(String associationVersion) {
        this.setAssociationVersion(associationVersion);
        return this;
    }

    public void setDocumentVersion(String documentVersion) {
        this.documentVersion = documentVersion;
    }

    public String getDocumentVersion() {
        return this.documentVersion;
    }

    public Association withDocumentVersion(String documentVersion) {
        this.setDocumentVersion(documentVersion);
        return this;
    }

    public List<Target> getTargets() {
        if (this.targets == null) {
            this.targets = new SdkInternalList();
        }
        return this.targets;
    }

    public void setTargets(Collection<Target> targets) {
        if (targets == null) {
            this.targets = null;
            return;
        }
        this.targets = new SdkInternalList(targets);
    }

    public Association withTargets(Target ... targets) {
        if (this.targets == null) {
            this.setTargets((Collection<Target>)new SdkInternalList(targets.length));
        }
        for (Target ele : targets) {
            this.targets.add((Object)ele);
        }
        return this;
    }

    public Association withTargets(Collection<Target> targets) {
        this.setTargets(targets);
        return this;
    }

    public void setLastExecutionDate(Date lastExecutionDate) {
        this.lastExecutionDate = lastExecutionDate;
    }

    public Date getLastExecutionDate() {
        return this.lastExecutionDate;
    }

    public Association withLastExecutionDate(Date lastExecutionDate) {
        this.setLastExecutionDate(lastExecutionDate);
        return this;
    }

    public void setOverview(AssociationOverview overview) {
        this.overview = overview;
    }

    public AssociationOverview getOverview() {
        return this.overview;
    }

    public Association withOverview(AssociationOverview overview) {
        this.setOverview(overview);
        return this;
    }

    public void setScheduleExpression(String scheduleExpression) {
        this.scheduleExpression = scheduleExpression;
    }

    public String getScheduleExpression() {
        return this.scheduleExpression;
    }

    public Association withScheduleExpression(String scheduleExpression) {
        this.setScheduleExpression(scheduleExpression);
        return this;
    }

    public void setAssociationName(String associationName) {
        this.associationName = associationName;
    }

    public String getAssociationName() {
        return this.associationName;
    }

    public Association withAssociationName(String associationName) {
        this.setAssociationName(associationName);
        return this;
    }

    public void setScheduleOffset(Integer scheduleOffset) {
        this.scheduleOffset = scheduleOffset;
    }

    public Integer getScheduleOffset() {
        return this.scheduleOffset;
    }

    public Association withScheduleOffset(Integer scheduleOffset) {
        this.setScheduleOffset(scheduleOffset);
        return this;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public Association withDuration(Integer duration) {
        this.setDuration(duration);
        return this;
    }

    public List<Map<String, List<String>>> getTargetMaps() {
        if (this.targetMaps == null) {
            this.targetMaps = new SdkInternalList();
        }
        return this.targetMaps;
    }

    public void setTargetMaps(Collection<Map<String, List<String>>> targetMaps) {
        if (targetMaps == null) {
            this.targetMaps = null;
            return;
        }
        this.targetMaps = new SdkInternalList(targetMaps);
    }

    public Association withTargetMaps(Map<String, List<String>> ... targetMaps) {
        if (this.targetMaps == null) {
            this.setTargetMaps((Collection<Map<String, List<String>>>)new SdkInternalList(targetMaps.length));
        }
        for (Map<String, List<String>> ele : targetMaps) {
            this.targetMaps.add(ele);
        }
        return this;
    }

    public Association withTargetMaps(Collection<Map<String, List<String>>> targetMaps) {
        this.setTargetMaps(targetMaps);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: ").append(this.getInstanceId()).append(",");
        }
        if (this.getAssociationId() != null) {
            sb.append("AssociationId: ").append(this.getAssociationId()).append(",");
        }
        if (this.getAssociationVersion() != null) {
            sb.append("AssociationVersion: ").append(this.getAssociationVersion()).append(",");
        }
        if (this.getDocumentVersion() != null) {
            sb.append("DocumentVersion: ").append(this.getDocumentVersion()).append(",");
        }
        if (this.getTargets() != null) {
            sb.append("Targets: ").append(this.getTargets()).append(",");
        }
        if (this.getLastExecutionDate() != null) {
            sb.append("LastExecutionDate: ").append(this.getLastExecutionDate()).append(",");
        }
        if (this.getOverview() != null) {
            sb.append("Overview: ").append(this.getOverview()).append(",");
        }
        if (this.getScheduleExpression() != null) {
            sb.append("ScheduleExpression: ").append(this.getScheduleExpression()).append(",");
        }
        if (this.getAssociationName() != null) {
            sb.append("AssociationName: ").append(this.getAssociationName()).append(",");
        }
        if (this.getScheduleOffset() != null) {
            sb.append("ScheduleOffset: ").append(this.getScheduleOffset()).append(",");
        }
        if (this.getDuration() != null) {
            sb.append("Duration: ").append(this.getDuration()).append(",");
        }
        if (this.getTargetMaps() != null) {
            sb.append("TargetMaps: ").append(this.getTargetMaps());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Association)) {
            return false;
        }
        Association other = (Association)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getAssociationId() == null ^ this.getAssociationId() == null) {
            return false;
        }
        if (other.getAssociationId() != null && !other.getAssociationId().equals(this.getAssociationId())) {
            return false;
        }
        if (other.getAssociationVersion() == null ^ this.getAssociationVersion() == null) {
            return false;
        }
        if (other.getAssociationVersion() != null && !other.getAssociationVersion().equals(this.getAssociationVersion())) {
            return false;
        }
        if (other.getDocumentVersion() == null ^ this.getDocumentVersion() == null) {
            return false;
        }
        if (other.getDocumentVersion() != null && !other.getDocumentVersion().equals(this.getDocumentVersion())) {
            return false;
        }
        if (other.getTargets() == null ^ this.getTargets() == null) {
            return false;
        }
        if (other.getTargets() != null && !other.getTargets().equals(this.getTargets())) {
            return false;
        }
        if (other.getLastExecutionDate() == null ^ this.getLastExecutionDate() == null) {
            return false;
        }
        if (other.getLastExecutionDate() != null && !other.getLastExecutionDate().equals(this.getLastExecutionDate())) {
            return false;
        }
        if (other.getOverview() == null ^ this.getOverview() == null) {
            return false;
        }
        if (other.getOverview() != null && !other.getOverview().equals(this.getOverview())) {
            return false;
        }
        if (other.getScheduleExpression() == null ^ this.getScheduleExpression() == null) {
            return false;
        }
        if (other.getScheduleExpression() != null && !other.getScheduleExpression().equals(this.getScheduleExpression())) {
            return false;
        }
        if (other.getAssociationName() == null ^ this.getAssociationName() == null) {
            return false;
        }
        if (other.getAssociationName() != null && !other.getAssociationName().equals(this.getAssociationName())) {
            return false;
        }
        if (other.getScheduleOffset() == null ^ this.getScheduleOffset() == null) {
            return false;
        }
        if (other.getScheduleOffset() != null && !other.getScheduleOffset().equals(this.getScheduleOffset())) {
            return false;
        }
        if (other.getDuration() == null ^ this.getDuration() == null) {
            return false;
        }
        if (other.getDuration() != null && !other.getDuration().equals(this.getDuration())) {
            return false;
        }
        if (other.getTargetMaps() == null ^ this.getTargetMaps() == null) {
            return false;
        }
        return other.getTargetMaps() == null || other.getTargetMaps().equals(this.getTargetMaps());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getAssociationId() == null ? 0 : this.getAssociationId().hashCode());
        hashCode = 31 * hashCode + (this.getAssociationVersion() == null ? 0 : this.getAssociationVersion().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentVersion() == null ? 0 : this.getDocumentVersion().hashCode());
        hashCode = 31 * hashCode + (this.getTargets() == null ? 0 : this.getTargets().hashCode());
        hashCode = 31 * hashCode + (this.getLastExecutionDate() == null ? 0 : this.getLastExecutionDate().hashCode());
        hashCode = 31 * hashCode + (this.getOverview() == null ? 0 : this.getOverview().hashCode());
        hashCode = 31 * hashCode + (this.getScheduleExpression() == null ? 0 : this.getScheduleExpression().hashCode());
        hashCode = 31 * hashCode + (this.getAssociationName() == null ? 0 : this.getAssociationName().hashCode());
        hashCode = 31 * hashCode + (this.getScheduleOffset() == null ? 0 : this.getScheduleOffset().hashCode());
        hashCode = 31 * hashCode + (this.getDuration() == null ? 0 : this.getDuration().hashCode());
        hashCode = 31 * hashCode + (this.getTargetMaps() == null ? 0 : this.getTargetMaps().hashCode());
        return hashCode;
    }

    public Association clone() {
        try {
            return (Association)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AssociationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

